/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.fireextinguisher.block;

import de.markusbordihn.fireextinguisher.block.FireExtinguisherSignPosition;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;

public class ExitSign
extends Block {
    public static final String NAME = "exit_sign";
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final EnumProperty<AttachFace> ATTACH_FACE = BlockStateProperties.field_208158_K;
    protected static final VoxelShape CEILING_NORTH_SOUTH_AABB = Block.func_208617_a((double)0.0, (double)4.0, (double)7.0, (double)16.0, (double)12.0, (double)9.0);
    protected static final VoxelShape CEILING_EAST_WEST_AABB = Block.func_208617_a((double)7.0, (double)4.0, (double)0.0, (double)9.0, (double)12.0, (double)16.0);
    protected static final VoxelShape FLOOR_NORTH_SOUTH_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)7.0, (double)16.0, (double)8.0, (double)9.0);
    protected static final VoxelShape FLOOR_EAST_WEST_AABB = Block.func_208617_a((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)8.0, (double)16.0);
    protected static final VoxelShape SHAPE_NORTH_AABB = Block.func_208617_a((double)0.0, (double)4.0, (double)13.75, (double)16.0, (double)12.0, (double)16.0);
    protected static final VoxelShape SHAPE_EAST_AABB = Block.func_208617_a((double)0.0, (double)4.0, (double)0.0, (double)2.25, (double)12.0, (double)16.0);
    protected static final VoxelShape SHAPE_SOUTH_AABB = Block.func_208617_a((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)12.0, (double)2.25);
    protected static final VoxelShape SHAPE_WEST_AABB = Block.func_208617_a((double)13.75, (double)4.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);

    public ExitSign(AbstractBlock.Properties properties) {
        super(properties.func_235838_a_(blockState -> 15));
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a(ATTACH_FACE, (Comparable)AttachFace.FLOOR));
    }

    public VoxelShape func_220053_a(BlockState blockState, IBlockReader worldIn, BlockPos blockPos, ISelectionContext context) {
        AttachFace attachFace = (AttachFace)blockState.func_177229_b(ATTACH_FACE);
        Direction facing = (Direction)blockState.func_177229_b((Property)FireExtinguisherSignPosition.FACING);
        if (attachFace == AttachFace.CEILING) {
            if (facing == Direction.NORTH || facing == Direction.SOUTH) {
                return CEILING_NORTH_SOUTH_AABB;
            }
            if (facing == Direction.EAST || facing == Direction.WEST) {
                return CEILING_EAST_WEST_AABB;
            }
        }
        if (attachFace == AttachFace.FLOOR) {
            if (facing == Direction.NORTH || facing == Direction.SOUTH) {
                return FLOOR_NORTH_SOUTH_AABB;
            }
            if (facing == Direction.EAST || facing == Direction.WEST) {
                return FLOOR_EAST_WEST_AABB;
            }
        }
        switch (facing) {
            case NORTH: {
                return SHAPE_NORTH_AABB;
            }
            case EAST: {
                return SHAPE_EAST_AABB;
            }
            case SOUTH: {
                return SHAPE_SOUTH_AABB;
            }
            case WEST: {
                return SHAPE_WEST_AABB;
            }
        }
        return SHAPE_NORTH_AABB;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> blockState) {
        blockState.func_206894_a(new Property[]{ATTACH_FACE, FACING});
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction direction = context.func_196000_l();
        BlockState blockState = context.func_195991_k().func_180495_p(context.func_195995_a().func_177972_a(direction.func_176734_d()));
        Direction faceDirection = blockState.func_203425_a((Block)this) && blockState.func_177229_b((Property)FACING) == direction ? direction.func_176734_d() : direction;
        AttachFace attachFace = AttachFace.FLOOR;
        if (faceDirection == Direction.DOWN) {
            attachFace = AttachFace.CEILING;
        } else if (faceDirection != Direction.UP) {
            Double relativeClickLocation = context.func_221532_j().field_72448_b % 1.0;
            attachFace = relativeClickLocation < 0.2 ? AttachFace.FLOOR : (relativeClickLocation > 0.8 ? AttachFace.CEILING : AttachFace.WALL);
        }
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a(ATTACH_FACE, (Comparable)attachFace)).func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176734_d());
    }
}

