/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.fireextinguisher.item;

import de.markusbordihn.fireextinguisher.config.CommonConfig;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.AxeItem;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
public class FireAxeItem
extends AxeItem {
    protected static final Logger log = LogManager.getLogger((String)"Fire Extinguisher");
    public static final String NAME = "fire_axe";
    private static final CommonConfig.Config COMMON = CommonConfig.COMMON;
    private static int fireAxtRadius = (Integer)FireAxeItem.COMMON.fireAxtRadius.get();

    public FireAxeItem(IItemTier tier, float attackBase, float attackSpeed, Item.Properties properties) {
        super(tier, attackBase, attackSpeed, properties);
    }

    @SubscribeEvent
    public static void handleServerAboutToStartEvent(FMLServerAboutToStartEvent event) {
        fireAxtRadius = (Integer)FireAxeItem.COMMON.fireAxtRadius.get();
    }

    public static void stopFire(World level, PlayerEntity player, Hand hand, BlockPos targetBlockPos, ItemStack itemStack) {
        Iterable blockPositions = BlockPos.func_239583_a_((BlockPos)targetBlockPos.func_177984_a(), (int)fireAxtRadius, (int)fireAxtRadius, (int)fireAxtRadius);
        boolean hasStoppedFire = false;
        for (BlockPos blockPos : blockPositions) {
            BlockState blockState = level.func_180495_p(blockPos);
            if (!blockState.func_203425_a(Blocks.field_150480_ab)) continue;
            log.debug("[FireAxe] Removing Fire Block {} at {}", (Object)blockState, (Object)blockPos);
            level.func_217377_a(blockPos, false);
            FireAxeItem.stopFireSound(level, player);
            hasStoppedFire = true;
        }
        if (hasStoppedFire) {
            FireAxeItem.hurtAndBreak(level, itemStack, player, hand);
        }
    }

    public static void stopFireSound(World level, PlayerEntity player) {
        if (level.field_72995_K) {
            player.func_184185_a(SoundEvents.field_187646_bt, 1.0f, 1.0f);
        }
    }

    public static void hurtAndBreak(World level, ItemStack itemStack, PlayerEntity player, Hand hand) {
        if (!level.field_72995_K) {
            itemStack.func_222118_a(1, (LivingEntity)player, serverPlayer -> serverPlayer.func_213334_d(hand));
        }
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World level = context.func_195991_k();
        BlockPos blockPos = context.func_195995_a();
        PlayerEntity player = context.func_195999_j();
        ItemStack itemStack = context.func_195996_i();
        Hand interactionHand = context.func_221531_n();
        FireAxeItem.stopFire(level, player, interactionHand, blockPos, itemStack);
        return ActionResultType.func_233537_a_((boolean)context.func_195991_k().func_201670_d());
    }

    public boolean func_179218_a(ItemStack itemStack, World level, BlockState blockState, BlockPos blockPos, LivingEntity livingEntity) {
        if (livingEntity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)livingEntity;
            FireAxeItem.stopFire(level, player, player.func_184600_cs(), blockPos, itemStack);
        }
        return super.func_179218_a(itemStack, level, blockState, blockPos, livingEntity);
    }

    public boolean func_234687_u_() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack itemStack, @Nullable World level, List<ITextComponent> tooltipList, ITooltipFlag tooltipFlag) {
        tooltipList.add((ITextComponent)new TranslationTextComponent("text.fire_extinguisher.fire_axe_description", new Object[]{fireAxtRadius}));
        tooltipList.add((ITextComponent)new TranslationTextComponent("text.fire_extinguisher.fire_axe_use").func_240699_a_(TextFormatting.GREEN));
    }
}

