/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.fireextinguisher.item;

import de.markusbordihn.fireextinguisher.block.FireExtinguisherBlock;
import de.markusbordihn.fireextinguisher.config.CommonConfig;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.IVanishable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.BlazeEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
public class FireExtinguisherItem
extends BlockItem
implements IVanishable {
    protected static final Logger log = LogManager.getLogger((String)"Fire Extinguisher");
    public static final String NAME = "fire_extinguisher";
    private static final CommonConfig.Config COMMON = CommonConfig.COMMON;
    private static int fireExtinguisherRadius = (Integer)FireExtinguisherItem.COMMON.fireExtinguisherRadius.get();
    private static final double X_SHIFT = 0.0;
    private static final double Y_SHIFT = 1.6;
    private static final double Z_SHIFT = 0.0;
    private static final int PARTICLE_FRAMES = 8;
    private static final int ATTACK_EFFECT_DURATION = 200;

    public FireExtinguisherItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    @SubscribeEvent
    public static void handleServerAboutToStartEvent(FMLServerAboutToStartEvent event) {
        fireExtinguisherRadius = (Integer)FireExtinguisherItem.COMMON.fireExtinguisherRadius.get();
    }

    public static void stopFireAnimation(PlayerEntity player, World level, BlockPos blockPos) {
        if (!level.field_72995_K) {
            return;
        }
        double x = player.func_226277_ct_();
        double y = player.func_226278_cu_();
        double z = player.func_226281_cx_();
        x = x >= 0.0 ? x + 0.0 : x - 0.0;
        y = y >= 0.0 ? y + 1.6 : y - 1.6;
        double d = z = z >= 0.0 ? z + 0.0 : z - 0.0;
        if (blockPos != null) {
            double targetX = (double)blockPos.func_177958_n() + 0.5;
            double targetY = (double)blockPos.func_177956_o() + 0.5;
            double targetZ = (double)blockPos.func_177952_p() + 0.5;
            double targetXRatio = (targetX - x) / 8.0;
            double targetYRatio = (targetY - y) / 8.0;
            double targetZRatio = (targetZ - z) / 8.0;
            for (int i = 0; i < 8; ++i) {
                level.func_195594_a((IParticleData)ParticleTypes.field_197613_f, x += targetXRatio, y += targetYRatio, z += targetZRatio, 0.0, 0.0, 0.0);
            }
        }
    }

    public static void stopFire(World level, PlayerEntity player, Hand hand, BlockPos targetBlockPos, ItemStack itemStack) {
        Iterable blockPositions = BlockPos.func_239583_a_((BlockPos)targetBlockPos.func_177984_a(), (int)fireExtinguisherRadius, (int)fireExtinguisherRadius, (int)fireExtinguisherRadius);
        boolean hasStoppedFire = false;
        for (BlockPos blockPos : blockPositions) {
            BlockState blockState = level.func_180495_p(blockPos);
            if (!blockState.func_203425_a(Blocks.field_150480_ab)) continue;
            log.debug("[FireExtinguisher] Removing Fire Block {} at {}", (Object)blockState, (Object)blockPos);
            level.func_217377_a(blockPos, false);
            FireExtinguisherItem.stopFireSound(level, player);
            hasStoppedFire = true;
        }
        if (hasStoppedFire) {
            FireExtinguisherItem.hurtAndBreak(level, itemStack, player, hand);
        }
    }

    public static void stopFireSound(World level, PlayerEntity player) {
        if (level.field_72995_K) {
            player.func_184185_a(SoundEvents.field_187646_bt, 1.0f, 1.0f);
        }
    }

    public static void hurtAndBreak(World level, ItemStack itemStack, PlayerEntity player, Hand hand) {
        if (!level.field_72995_K) {
            itemStack.func_222118_a(1, (LivingEntity)player, serverPlayer -> serverPlayer.func_213334_d(hand));
        }
    }

    public boolean func_195938_a(BlockState blockState, World level, BlockPos blockPos, PlayerEntity player) {
        if (blockState.func_177230_c() instanceof FireExtinguisherBlock) {
            return true;
        }
        return player.func_225608_bj_();
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World level = context.func_195991_k();
        BlockPos blockPos = context.func_195995_a();
        PlayerEntity player = context.func_195999_j();
        ItemStack itemStack = context.func_195996_i();
        Hand hand = context.func_221531_n();
        if (player != null && player.func_225608_bj_()) {
            return super.func_195939_a(context);
        }
        FireExtinguisherItem.stopFireAnimation(player, level, blockPos);
        FireExtinguisherItem.stopFire(level, player, hand, blockPos, itemStack);
        return ActionResultType.FAIL;
    }

    public ActionResult<ItemStack> func_77659_a(World level, PlayerEntity player, Hand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        if (player.func_70027_ad()) {
            if (player.func_223314_ad() > 2) {
                player.func_241209_g_(2);
            }
            FireExtinguisherItem.stopFireAnimation(player, level, player.func_233580_cy_());
            FireExtinguisherItem.stopFireSound(level, player);
            FireExtinguisherItem.hurtAndBreak(level, itemStack, player, hand);
        }
        return ActionResult.func_226250_c_((Object)itemStack);
    }

    public ActionResultType func_111207_a(ItemStack itemStack, PlayerEntity player, LivingEntity livingEntity, Hand hand) {
        BlockPos blockPos = livingEntity.func_233580_cy_();
        World level = player.field_70170_p;
        FireExtinguisherItem.stopFireAnimation(player, level, blockPos.func_177984_a());
        if (livingEntity.func_70027_ad()) {
            livingEntity.func_241209_g_(2);
        }
        if (!level.field_72995_K) {
            livingEntity.func_195064_c(new EffectInstance(Effects.field_76421_d, 200, 10));
            livingEntity.func_195064_c(new EffectInstance(Effects.field_204839_B, 200, 10));
            if (!(livingEntity instanceof PlayerEntity)) {
                float attackDamage = 0.5f;
                if (livingEntity instanceof BlazeEntity) {
                    attackDamage = 3.0f;
                }
                livingEntity.func_70097_a(DamageSource.field_76376_m, attackDamage);
            }
            FireExtinguisherItem.hurtAndBreak(level, itemStack, player, hand);
        } else {
            FireExtinguisherItem.stopFireSound(level, player);
        }
        return ActionResultType.PASS;
    }

    public int func_77626_a(ItemStack itemStack) {
        return 10;
    }

    public boolean func_234687_u_() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack itemStack, @Nullable World level, List<ITextComponent> tooltipList, ITooltipFlag tooltipFlag) {
        tooltipList.add((ITextComponent)new TranslationTextComponent("text.fire_extinguisher.fire_extinguisher_description", new Object[]{fireExtinguisherRadius}));
        tooltipList.add((ITextComponent)new TranslationTextComponent("text.fire_extinguisher.fire_extinguisher_use").func_240699_a_(TextFormatting.GREEN));
        tooltipList.add((ITextComponent)new TranslationTextComponent("text.fire_extinguisher.fire_extinguisher_place").func_240699_a_(TextFormatting.GRAY));
    }
}

