/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.fireextinguisher.item;

import de.markusbordihn.fireextinguisher.config.CommonConfig;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
public class FireHelmetItem
extends ArmorItem {
    protected static final Logger log = LogManager.getLogger((String)"Fire Extinguisher");
    public static final String NAME = "fire_helmet";
    private static final CommonConfig.Config COMMON = CommonConfig.COMMON;
    private static boolean fireProtectionEnabled = (Boolean)FireHelmetItem.COMMON.fireProtectionEnabled.get();
    private static int fireProtectionRenew = (Integer)FireHelmetItem.COMMON.fireProtectionRenew.get();
    private static int fireProtectionDuration = (Integer)FireHelmetItem.COMMON.fireProtectionDuration.get();
    private int ticker = 0;

    public FireHelmetItem(IArmorMaterial material, EquipmentSlotType slot, Item.Properties properties) {
        super(material, slot, properties);
    }

    @SubscribeEvent
    public static void handleServerAboutToStartEvent(FMLServerAboutToStartEvent event) {
        fireProtectionEnabled = (Boolean)FireHelmetItem.COMMON.fireProtectionEnabled.get();
        fireProtectionRenew = (Integer)FireHelmetItem.COMMON.fireProtectionRenew.get();
        fireProtectionDuration = (Integer)FireHelmetItem.COMMON.fireProtectionDuration.get();
    }

    public boolean func_234687_u_() {
        return true;
    }

    public void onArmorTick(ItemStack stack, World level, PlayerEntity player) {
        if (fireProtectionEnabled && !level.field_72995_K && this.ticker++ > fireProtectionRenew && !player.func_70644_a(Effects.field_76426_n)) {
            player.func_195064_c(new EffectInstance(Effects.field_76426_n, fireProtectionDuration));
            this.ticker = 0;
        }
        super.onArmorTick(stack, level, player);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack itemStack, @Nullable World level, List<ITextComponent> tooltipList, ITooltipFlag tooltipFlag) {
        tooltipList.add((ITextComponent)new TranslationTextComponent("text.fire_extinguisher.fire_helmet_description"));
        if (fireProtectionEnabled) {
            tooltipList.add((ITextComponent)new TranslationTextComponent("text.fire_extinguisher.fire_armor_config", new Object[]{(double)Math.round((double)fireProtectionRenew / 20.0 * 10.0) / 10.0, (double)Math.round((double)fireProtectionDuration / 20.0 * 10.0) / 10.0}).func_240699_a_(TextFormatting.GREEN));
        }
    }
}

