/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.fireextinguisher.item;

import de.markusbordihn.fireextinguisher.config.CommonConfig;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
public class FireLeggingsItem
extends ArmorItem {
    protected static final Logger log = LogManager.getLogger((String)"Fire Extinguisher");
    public static final String NAME = "fire_leggings";
    private static final CommonConfig.Config COMMON = CommonConfig.COMMON;
    private static boolean fireLeggingsSlowDownEnabled = (Boolean)FireLeggingsItem.COMMON.fireLeggingsSlowDownEnabled.get();
    private static boolean fireProtectionEnabled = (Boolean)FireLeggingsItem.COMMON.fireProtectionEnabled.get();
    private static int fireProtectionRenew = (Integer)FireLeggingsItem.COMMON.fireProtectionRenew.get();
    private static int fireProtectionDuration = (Integer)FireLeggingsItem.COMMON.fireProtectionDuration.get();
    private int ticker = 0;

    public FireLeggingsItem(IArmorMaterial material, EquipmentSlotType slot, Item.Properties properties) {
        super(material, slot, properties);
    }

    @SubscribeEvent
    public static void handleServerAboutToStartEvent(FMLServerAboutToStartEvent event) {
        fireLeggingsSlowDownEnabled = (Boolean)FireLeggingsItem.COMMON.fireLeggingsSlowDownEnabled.get();
        fireProtectionEnabled = (Boolean)FireLeggingsItem.COMMON.fireProtectionEnabled.get();
        fireProtectionRenew = (Integer)FireLeggingsItem.COMMON.fireProtectionRenew.get();
        fireProtectionDuration = (Integer)FireLeggingsItem.COMMON.fireProtectionDuration.get();
    }

    public boolean func_234687_u_() {
        return true;
    }

    public void onArmorTick(ItemStack stack, World level, PlayerEntity player) {
        if (fireProtectionEnabled && !level.field_72995_K && this.ticker++ > fireProtectionRenew && !player.func_70644_a(Effects.field_76426_n)) {
            player.func_195064_c(new EffectInstance(Effects.field_76426_n, fireProtectionDuration));
            if (fireLeggingsSlowDownEnabled) {
                player.func_195064_c(new EffectInstance(Effects.field_76421_d, fireProtectionDuration));
            }
            this.ticker = 0;
        }
        super.onArmorTick(stack, level, player);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack itemStack, @Nullable World level, List<ITextComponent> tooltipList, ITooltipFlag tooltipFlag) {
        tooltipList.add((ITextComponent)new TranslationTextComponent("text.fire_extinguisher.fire_leggings_description"));
        if (fireProtectionEnabled) {
            tooltipList.add((ITextComponent)new TranslationTextComponent("text.fire_extinguisher.fire_armor_config", new Object[]{(double)Math.round((double)fireProtectionRenew / 20.0 * 10.0) / 10.0, (double)Math.round((double)fireProtectionDuration / 20.0 * 10.0) / 10.0}).func_240699_a_(TextFormatting.GREEN));
        }
        if (fireLeggingsSlowDownEnabled) {
            tooltipList.add((ITextComponent)new TranslationTextComponent("text.fire_extinguisher.fire_armor_slow_down").func_240699_a_(TextFormatting.DARK_RED));
        }
    }
}

