/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.fireextinguisher.item;

import de.markusbordihn.fireextinguisher.config.CommonConfig;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
public class FireAxeItem
extends AxeItem {
    protected static final Logger log = LogManager.getLogger((String)"Fire Extinguisher");
    public static final String NAME = "fire_axe";
    private static final CommonConfig.Config COMMON = CommonConfig.COMMON;
    private static int fireAxtRadius = (Integer)FireAxeItem.COMMON.fireAxtRadius.get();

    public FireAxeItem(Tier tier, float attackBase, float attackSpeed, Item.Properties properties) {
        super(tier, attackBase, attackSpeed, properties);
    }

    @SubscribeEvent
    public static void handleServerAboutToStartEvent(ServerAboutToStartEvent event) {
        fireAxtRadius = (Integer)FireAxeItem.COMMON.fireAxtRadius.get();
    }

    public void stopFire(Level level, Player player, InteractionHand hand, BlockPos targetBlockPos, ItemStack itemStack) {
        Iterable blockPositions = BlockPos.m_121925_((BlockPos)targetBlockPos.m_7494_(), (int)fireAxtRadius, (int)fireAxtRadius, (int)fireAxtRadius);
        boolean hasStoppedFire = false;
        for (BlockPos blockPos : blockPositions) {
            BlockState blockState = level.m_8055_(blockPos);
            if (!blockState.m_60713_(Blocks.f_50083_)) continue;
            level.m_7471_(blockPos, false);
            if (level.f_46443_) {
                player.m_5496_(SoundEvents.f_11937_, 1.0f, 1.0f);
            }
            hasStoppedFire = true;
        }
        if (!level.f_46443_ && hasStoppedFire) {
            itemStack.m_41622_(1, (LivingEntity)player, serverPlayer -> serverPlayer.m_21190_(hand));
        }
    }

    public boolean m_6813_(ItemStack itemStack, Level level, BlockState blockState, BlockPos blockPos, LivingEntity livingEntity) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            this.stopFire(level, player, player.m_7655_(), blockPos, itemStack);
        }
        return super.m_6813_(itemStack, level, blockState, blockPos, livingEntity);
    }

    public boolean m_41475_() {
        return true;
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> tooltipList, TooltipFlag tooltipFlag) {
        tooltipList.add((Component)new TranslatableComponent("text.fire_extinguisher.fire_axe_description", new Object[]{fireAxtRadius}));
        tooltipList.add((Component)new TranslatableComponent("text.fire_extinguisher.fire_axe_use").m_130940_(ChatFormatting.GREEN));
    }
}

