/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.fireextinguisher.item;

import de.markusbordihn.fireextinguisher.config.CommonConfig;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
public class FireLeggingsItem
extends ArmorItem {
    protected static final Logger log = LogManager.getLogger((String)"Fire Extinguisher");
    public static final String NAME = "fire_leggings";
    private static final CommonConfig.Config COMMON = CommonConfig.COMMON;
    private static boolean fireLeggingsSlowDownEnabled = (Boolean)FireLeggingsItem.COMMON.fireLeggingsSlowDownEnabled.get();
    private static boolean fireProtectionEnabled = (Boolean)FireLeggingsItem.COMMON.fireProtectionEnabled.get();
    private static int fireProtectionRenew = (Integer)FireLeggingsItem.COMMON.fireProtectionRenew.get();
    private static int fireProtectionDuration = (Integer)FireLeggingsItem.COMMON.fireProtectionDuration.get();
    private int ticker = 0;

    public FireLeggingsItem(ArmorMaterial material, EquipmentSlot slot, Item.Properties properties) {
        super(material, slot, properties);
    }

    @SubscribeEvent
    public static void handleServerAboutToStartEvent(ServerAboutToStartEvent event) {
        fireLeggingsSlowDownEnabled = (Boolean)FireLeggingsItem.COMMON.fireLeggingsSlowDownEnabled.get();
        fireProtectionEnabled = (Boolean)FireLeggingsItem.COMMON.fireProtectionEnabled.get();
        fireProtectionRenew = (Integer)FireLeggingsItem.COMMON.fireProtectionRenew.get();
        fireProtectionDuration = (Integer)FireLeggingsItem.COMMON.fireProtectionDuration.get();
    }

    public boolean m_41475_() {
        return true;
    }

    public void onArmorTick(ItemStack stack, Level level, Player player) {
        if (fireProtectionEnabled && !level.f_46443_ && this.ticker++ > fireProtectionRenew && !player.m_21023_(MobEffects.f_19607_)) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19607_, fireProtectionDuration));
            if (fireLeggingsSlowDownEnabled) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, fireProtectionDuration));
            }
            this.ticker = 0;
        }
        super.onArmorTick(stack, level, player);
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> tooltipList, TooltipFlag tooltipFlag) {
        tooltipList.add((Component)new TranslatableComponent("text.fire_extinguisher.fire_leggings_description"));
        if (fireProtectionEnabled) {
            tooltipList.add((Component)new TranslatableComponent("text.fire_extinguisher.fire_armor_config", new Object[]{(double)Math.round((double)fireProtectionRenew / 20.0 * 10.0) / 10.0, (double)Math.round((double)fireProtectionDuration / 20.0 * 10.0) / 10.0}).m_130940_(ChatFormatting.GREEN));
        }
        if (fireLeggingsSlowDownEnabled) {
            tooltipList.add((Component)new TranslatableComponent("text.fire_extinguisher.fire_armor_slow_down").m_130940_(ChatFormatting.DARK_RED));
        }
    }
}

