/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.fireextinguisher.block;

import de.markusbordihn.fireextinguisher.block.FireExtinguisherSignPosition;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ExitSign
extends Block {
    public static final String NAME = "exit_sign";
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final EnumProperty<AttachFace> ATTACH_FACE = BlockStateProperties.f_61376_;
    protected static final VoxelShape CEILING_NORTH_SOUTH_AABB = Block.m_49796_((double)0.0, (double)4.0, (double)7.0, (double)16.0, (double)12.0, (double)9.0);
    protected static final VoxelShape CEILING_EAST_WEST_AABB = Block.m_49796_((double)7.0, (double)4.0, (double)0.0, (double)9.0, (double)12.0, (double)16.0);
    protected static final VoxelShape FLOOR_NORTH_SOUTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)7.0, (double)16.0, (double)8.0, (double)9.0);
    protected static final VoxelShape FLOOR_EAST_WEST_AABB = Block.m_49796_((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)8.0, (double)16.0);
    protected static final VoxelShape SHAPE_NORTH_AABB = Block.m_49796_((double)0.0, (double)4.0, (double)13.75, (double)16.0, (double)12.0, (double)16.0);
    protected static final VoxelShape SHAPE_EAST_AABB = Block.m_49796_((double)0.0, (double)4.0, (double)0.0, (double)2.25, (double)12.0, (double)16.0);
    protected static final VoxelShape SHAPE_SOUTH_AABB = Block.m_49796_((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)12.0, (double)2.25);
    protected static final VoxelShape SHAPE_WEST_AABB = Block.m_49796_((double)13.75, (double)4.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);

    public ExitSign(BlockBehaviour.Properties properties) {
        super(properties.m_60953_(blockState -> 15));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(ATTACH_FACE, (Comparable)AttachFace.FLOOR));
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        AttachFace attachFace = (AttachFace)blockState.m_61143_(ATTACH_FACE);
        Direction facing = (Direction)blockState.m_61143_((Property)FireExtinguisherSignPosition.FACING);
        if (attachFace == AttachFace.CEILING) {
            if (facing == Direction.NORTH || facing == Direction.SOUTH) {
                return CEILING_NORTH_SOUTH_AABB;
            }
            if (facing == Direction.EAST || facing == Direction.WEST) {
                return CEILING_EAST_WEST_AABB;
            }
        }
        if (attachFace == AttachFace.FLOOR) {
            if (facing == Direction.NORTH || facing == Direction.SOUTH) {
                return FLOOR_NORTH_SOUTH_AABB;
            }
            if (facing == Direction.EAST || facing == Direction.WEST) {
                return FLOOR_EAST_WEST_AABB;
            }
        }
        switch (facing) {
            case NORTH: {
                return SHAPE_NORTH_AABB;
            }
            case EAST: {
                return SHAPE_EAST_AABB;
            }
            case SOUTH: {
                return SHAPE_SOUTH_AABB;
            }
            case WEST: {
                return SHAPE_WEST_AABB;
            }
        }
        return SHAPE_NORTH_AABB;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> blockState) {
        blockState.m_61104_(new Property[]{ATTACH_FACE, FACING});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction direction = context.m_43719_();
        BlockState blockState = context.m_43725_().m_8055_(context.m_8083_().m_121945_(direction.m_122424_()));
        Direction faceDirection = blockState.m_60713_((Block)this) && blockState.m_61143_((Property)FACING) == direction ? direction.m_122424_() : direction;
        AttachFace attachFace = AttachFace.FLOOR;
        if (faceDirection == Direction.DOWN) {
            attachFace = AttachFace.CEILING;
        } else if (faceDirection != Direction.UP) {
            Double relativeClickLocation = context.m_43720_().f_82480_ % 1.0;
            attachFace = relativeClickLocation < 0.2 ? AttachFace.FLOOR : (relativeClickLocation > 0.8 ? AttachFace.CEILING : AttachFace.WALL);
        }
        return (BlockState)((BlockState)this.m_49966_().m_61124_(ATTACH_FACE, (Comparable)attachFace)).m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }
}

