/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.fireextinguisher.item;

import de.markusbordihn.fireextinguisher.block.FireExtinguisherBlock;
import de.markusbordihn.fireextinguisher.config.CommonConfig;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FireExtinguisherItem
extends BlockItem
implements Vanishable {
    protected static final Logger log = LogManager.getLogger((String)"Fire Extinguisher");
    public static final String NAME = "fire_extinguisher";
    private static final CommonConfig.Config COMMON = CommonConfig.COMMON;
    private static final double X_SHIFT = 0.0;
    private static final double Y_SHIFT = 1.6;
    private static final double Z_SHIFT = 0.0;
    private static final int PARTICLE_FRAMES = 8;
    private static final int ATTACK_EFFECT_DURATION = 200;

    public FireExtinguisherItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public static void stopFireAnimation(Player player, Level level, BlockPos blockPos) {
        if (!level.f_46443_) {
            return;
        }
        double x = player.m_20185_();
        double y = player.m_20186_();
        double z = player.m_20189_();
        x = x >= 0.0 ? x + 0.0 : x - 0.0;
        y = y >= 0.0 ? y + 1.6 : y - 1.6;
        double d = z = z >= 0.0 ? z + 0.0 : z - 0.0;
        if (blockPos != null) {
            double targetX = (double)blockPos.m_123341_() + 0.5;
            double targetY = (double)blockPos.m_123342_() + 0.5;
            double targetZ = (double)blockPos.m_123343_() + 0.5;
            double targetXRatio = (targetX - x) / 8.0;
            double targetYRatio = (targetY - y) / 8.0;
            double targetZRatio = (targetZ - z) / 8.0;
            for (int i = 0; i < 8; ++i) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123796_, x += targetXRatio, y += targetYRatio, z += targetZRatio, 0.0, 0.0, 0.0);
            }
        }
    }

    public static void stopFire(Level level, Player player, InteractionHand hand, BlockPos targetBlockPos, ItemStack itemStack) {
        Iterable blockPositions = BlockPos.m_121925_((BlockPos)targetBlockPos.m_7494_(), (int)((Integer)FireExtinguisherItem.COMMON.fireExtinguisherRadius.get()), (int)((Integer)FireExtinguisherItem.COMMON.fireExtinguisherRadius.get()), (int)((Integer)FireExtinguisherItem.COMMON.fireExtinguisherRadius.get()));
        boolean hasStoppedFire = false;
        for (BlockPos blockPos : blockPositions) {
            BlockState blockState = level.m_8055_(blockPos);
            if (!blockState.m_60713_(Blocks.f_50083_)) continue;
            if (!level.f_46443_) {
                log.debug("[FireExtinguisher] Removing Fire Block {} at {}", (Object)blockState, (Object)blockPos);
                level.m_7471_(blockPos, false);
            }
            if (level.f_46443_) {
                FireExtinguisherItem.stopFireSound(level, player);
            }
            hasStoppedFire = true;
        }
        if (hasStoppedFire) {
            FireExtinguisherItem.hurtAndBreak(level, itemStack, player, hand);
        }
    }

    public static void stopFireSound(Level level, Player player) {
        if (level.f_46443_) {
            player.m_5496_(SoundEvents.f_11937_, 1.0f, 1.0f);
        }
    }

    public static void hurtAndBreak(Level level, ItemStack itemStack, Player player, InteractionHand hand) {
        if (!level.f_46443_) {
            itemStack.m_41622_(1, (LivingEntity)player, serverPlayer -> serverPlayer.m_21190_(hand));
        }
    }

    public boolean m_6777_(BlockState blockState, Level level, BlockPos blockPos, Player player) {
        if (blockState.m_60734_() instanceof FireExtinguisherBlock) {
            return true;
        }
        return player.m_6144_();
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        BlockPos blockPos = context.m_8083_();
        Player player = context.m_43723_();
        ItemStack itemStack = context.m_43722_();
        InteractionHand interactionHand = context.m_43724_();
        if (player != null && player.m_6144_()) {
            return super.m_6225_(context);
        }
        FireExtinguisherItem.stopFireAnimation(player, level, blockPos);
        FireExtinguisherItem.stopFire(level, player, interactionHand, blockPos, itemStack);
        return InteractionResult.m_19078_((boolean)context.m_43725_().m_5776_());
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (player.m_6060_()) {
            if (player.m_20094_() > 2) {
                player.m_7311_(2);
            }
            FireExtinguisherItem.stopFireAnimation(player, level, player.m_20183_());
            FireExtinguisherItem.stopFireSound(level, player);
            FireExtinguisherItem.hurtAndBreak(level, itemStack, player, hand);
        }
        return InteractionResultHolder.m_19098_((Object)itemStack);
    }

    public InteractionResult m_6880_(ItemStack itemStack, Player player, LivingEntity livingEntity, InteractionHand hand) {
        BlockPos blockPos = livingEntity.m_20097_();
        Level level = player.m_9236_();
        FireExtinguisherItem.stopFireAnimation(player, player.m_9236_(), blockPos.m_7494_());
        livingEntity.m_146917_(1000);
        if (livingEntity.m_6060_()) {
            livingEntity.m_7311_(2);
        }
        if (!level.f_46443_) {
            livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 200, 10));
            livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19591_, 200, 10));
            if (!(livingEntity instanceof Player)) {
                float attackDamage = 0.5f;
                if (livingEntity instanceof Blaze) {
                    attackDamage = 3.0f;
                }
                livingEntity.m_6469_(level.m_269111_().m_269425_(), attackDamage);
            }
            FireExtinguisherItem.hurtAndBreak(level, itemStack, player, hand);
        } else {
            FireExtinguisherItem.stopFireSound(level, player);
        }
        return InteractionResult.PASS;
    }

    public int m_8105_(ItemStack itemStack) {
        return 10;
    }

    public boolean m_41475_() {
        return true;
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> tooltipList, TooltipFlag tooltipFlag) {
        tooltipList.add((Component)Component.m_237110_((String)"text.fire_extinguisher.fire_extinguisher_description", (Object[])new Object[]{FireExtinguisherItem.COMMON.fireExtinguisherRadius.get()}));
        tooltipList.add((Component)Component.m_237115_((String)"text.fire_extinguisher.fire_extinguisher_use").m_130940_(ChatFormatting.GREEN));
        tooltipList.add((Component)Component.m_237115_((String)"text.fire_extinguisher.fire_extinguisher_place").m_130940_(ChatFormatting.GRAY));
    }
}

