/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.fireextinguisher.config;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class CommonConfig {
    protected static final Logger log = LogManager.getLogger((String)"Fire Extinguisher");
    public static final ForgeConfigSpec commonSpec;
    public static final Config COMMON;

    protected CommonConfig() {
    }

    static {
        com.electronwill.nightconfig.core.Config.setInsertionOrderPreserved((boolean)true);
        Pair specPair = new ForgeConfigSpec.Builder().configure(Config::new);
        commonSpec = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Config)specPair.getLeft();
        log.info("{} Common config ...", (Object)"\ud83d\udd25Register Fire Extinguisher");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)commonSpec);
    }

    public static class Config {
        public final ForgeConfigSpec.IntValue fireExtinguisherRadius;
        public final ForgeConfigSpec.IntValue fireAxtRadius;
        public final ForgeConfigSpec.BooleanValue fireProtectionEnabled;
        public final ForgeConfigSpec.IntValue fireProtectionDuration;
        public final ForgeConfigSpec.IntValue fireProtectionRenew;
        public final ForgeConfigSpec.BooleanValue fireBootsSlowDownEnabled;
        public final ForgeConfigSpec.BooleanValue fireChestplateSlowDownEnabled;
        public final ForgeConfigSpec.BooleanValue fireLeggingsSlowDownEnabled;

        Config(ForgeConfigSpec.Builder builder) {
            builder.comment("Fire Extinguisher");
            builder.push("General");
            builder.pop();
            builder.push("Fire Extinguisher");
            this.fireExtinguisherRadius = builder.comment("The radius around the target block to stop fire.").defineInRange("fireExtinguisherRadius", 2, 0, 8);
            builder.pop();
            builder.push("Fire Axt");
            this.fireAxtRadius = builder.comment("The radius around the target block to stop fire.").defineInRange("fireAxtRadius", 1, 0, 8);
            builder.pop();
            builder.push("Fire Protection");
            this.fireProtectionEnabled = builder.comment("Enable/Disable fire protection affects from fire armor.").define("fireProtectionEnabled", true);
            this.fireProtectionRenew = builder.comment("Defines the amount of ticks after the fire protection get's renewed.").defineInRange("fireProtectionRenew", 40, 20, 6000);
            this.fireProtectionDuration = builder.comment("Defines the amount of ticks how long the fire protection is enabled.").defineInRange("fireProtectionDuration", 20, 10, 6000);
            builder.pop();
            builder.push("Fire Boots");
            this.fireBootsSlowDownEnabled = builder.comment("Enable/Disable slow down effect of wearing the fire boots.").define("fireBootsSlowDownEnabled", true);
            builder.pop();
            builder.push("Fire Chestplate");
            this.fireChestplateSlowDownEnabled = builder.comment("Enable/Disable slow down effect of wearing the fire chestplate.").define("fireChestplateSlowDownEnabled", true);
            builder.pop();
            builder.push("Fire Leggings");
            this.fireLeggingsSlowDownEnabled = builder.comment("Enable/Disable slow down effect of wearing the fire leggings.").define("fireLeggingsSlowDownEnabled", true);
            builder.pop();
        }
    }
}

