/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.client.renderer;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.stevekung.fishofthieves.client.renderer.entity.layers.GlowFishLayer;
import com.stevekung.fishofthieves.client.renderer.entity.layers.HeadphoneLayer;
import com.stevekung.fishofthieves.entity.FishVariant;
import com.stevekung.fishofthieves.entity.ThievesFish;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.class_1422;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_5617;
import net.minecraft.class_583;
import net.minecraft.class_927;

public abstract class ThievesFishRenderer<T extends class_1422, M extends class_583<T>>
extends class_927<T, M> {
    protected ThievesFishRenderer(class_5617.class_5618 context, M entityModel) {
        super(context, entityModel, 0.2f);
        this.method_4046(new GlowFishLayer(this));
        this.method_4046(new HeadphoneLayer(this, context));
    }

    public class_2960 getTextureLocation(T livingEntity) {
        return this.getTextureMap().get(((ThievesFish)livingEntity).getVariant());
    }

    protected void scale(T livingEntity, class_4587 poseStack, float partialTickTime) {
        float scale = ((ThievesFish)livingEntity).isTrophy() ? 1.0f : 0.5f;
        poseStack.method_22905(scale, scale, scale);
    }

    protected abstract Map<FishVariant, class_2960> getTextureMap();

    protected static Map<FishVariant, class_2960> createTextureByType(FishVariant[] variants, String name) {
        return (Map)class_156.method_654((Object)Maps.newHashMap(), map -> map.putAll((Map)Stream.of(variants).collect(ImmutableMap.toImmutableMap(Function.identity(), variant -> new class_2960("fishofthieves", "textures/entity/%s/%s.png".formatted(name, variant.getName()))))));
    }
}

