/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.entity;

import com.stevekung.fishofthieves.core.FishOfThieves;
import com.stevekung.fishofthieves.entity.FishVariant;
import com.stevekung.fishofthieves.entity.GlowFish;
import com.stevekung.fishofthieves.entity.PartyFish;
import com.stevekung.fishofthieves.registry.FOTTags;
import com.stevekung.fishofthieves.spawn.SpawnSelectors;
import java.util.Random;
import java.util.function.IntFunction;
import java.util.stream.Stream;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2487;
import net.minecraft.class_3730;
import org.jetbrains.annotations.Nullable;

public interface ThievesFish
extends GlowFish,
PartyFish {
    public static final class_1856 WORMS = class_1856.method_8106(FOTTags.WORMS);
    public static final class_1856 EARTHWORMS_FOOD = class_1856.method_8106(FOTTags.EARTHWORMS_FOOD);
    public static final class_1856 GRUBS_FOOD = class_1856.method_8106(FOTTags.GRUBS_FOOD);
    public static final class_1856 LEECHES_FOOD = class_1856.method_8106(FOTTags.LEECHES_FOOD);
    public static final String VARIANT_TAG = "Variant";
    public static final String TROPHY_TAG = "Trophy";
    public static final String HAS_FED_TAG = "HasFed";
    public static final String NAME_TAG = "Name";
    public static final String NO_FLIP = "NoFlip";

    public void setNoFlip(boolean var1);

    public boolean isNoFlip();

    public FishVariant getVariant();

    public int getSpawnVariantId(boolean var1);

    public void setVariant(int var1);

    public boolean isTrophy();

    public void setTrophy(boolean var1);

    public boolean hasFed();

    public void setHasFed(boolean var1);

    public boolean isFood(class_1799 var1);

    default public void saveToBucket(class_2487 compound) {
        compound.method_10569(VARIANT_TAG, this.getVariant().getId());
        compound.method_10556(TROPHY_TAG, this.isTrophy());
        compound.method_10556(HAS_FED_TAG, this.hasFed());
        compound.method_10582(NAME_TAG, this.getVariant().getName());
    }

    default public void loadFromBucket(class_2487 compound) {
        if (compound.method_10545(VARIANT_TAG)) {
            this.setVariant(compound.method_10550(VARIANT_TAG));
        }
        if (compound.method_10545(TROPHY_TAG)) {
            this.setTrophy(compound.method_10577(TROPHY_TAG));
        }
        if (compound.method_10545(HAS_FED_TAG)) {
            this.setHasFed(compound.method_10577(HAS_FED_TAG));
        }
    }

    default public class_1315 defaultFinalizeSpawn(class_1309 livingEntity, class_3730 reason, @Nullable class_1315 spawnData, @Nullable class_2487 dataTag) {
        if (reason == class_3730.field_16473 && dataTag != null && dataTag.method_10573(VARIANT_TAG, 3)) {
            this.setVariant(dataTag.method_10550(VARIANT_TAG));
            this.setTrophy(dataTag.method_10577(TROPHY_TAG));
            return spawnData;
        }
        if (livingEntity.method_6051().nextFloat() < FishOfThieves.CONFIG.spawnRate.trophyProbability) {
            this.setTrophy(true);
            livingEntity.method_6033(FishOfThieves.CONFIG.general.trophyMaxHealth);
        }
        this.setVariant(this.getSpawnVariantId(reason == class_3730.field_16473));
        return spawnData;
    }

    public static int getSpawnVariant(class_1309 livingEntity, FishVariant[] ids, IntFunction<FishVariant[]> generator, boolean random) {
        Object[] variants = random ? (FishVariant[])Stream.of(ids).toArray(generator) : (FishVariant[])Stream.of(ids).filter(variant -> variant.getCondition().test(SpawnSelectors.get(livingEntity))).toArray(generator);
        return ((FishVariant)class_156.method_27173((Object[])variants, (Random)livingEntity.method_6051())).getId();
    }
}

