/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.entity.animal;

import com.stevekung.fishofthieves.core.FishOfThieves;
import com.stevekung.fishofthieves.entity.AbstractThievesFish;
import com.stevekung.fishofthieves.entity.FishVariant;
import com.stevekung.fishofthieves.entity.ThievesFish;
import com.stevekung.fishofthieves.registry.FOTItems;
import com.stevekung.fishofthieves.registry.FOTSoundEvents;
import com.stevekung.fishofthieves.registry.FOTTags;
import com.stevekung.fishofthieves.spawn.SpawnConditionContext;
import com.stevekung.fishofthieves.spawn.SpawnSelectors;
import com.stevekung.fishofthieves.utils.Continentalness;
import com.stevekung.fishofthieves.utils.PeakTypes;
import com.stevekung.fishofthieves.utils.TerrainUtils;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1391;
import net.minecraft.class_1480;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2596;
import net.minecraft.class_2668;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3481;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4153;
import net.minecraft.class_4158;
import net.minecraft.class_4482;
import net.minecraft.class_6880;
import net.minecraft.class_6908;

public class Islehopper
extends AbstractThievesFish {
    private static final Map<FishVariant, class_2960> GLOW_BY_TYPE = Collections.singletonMap(Variant.AMETHYST, new class_2960("fishofthieves", "textures/entity/islehopper/amethyst_glow.png"));

    public Islehopper(class_1299<? extends Islehopper> entityType, class_1937 level) {
        super(entityType, level);
    }

    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(3, (class_1352)new class_1391((class_1314)this, 1.25, WORMS, false));
    }

    public class_1799 method_6452() {
        return new class_1799((class_1935)FOTItems.ISLEHOPPER_BUCKET);
    }

    protected class_3414 method_6002() {
        return FOTSoundEvents.ISLEHOPPER_DEATH;
    }

    protected class_3414 method_6011(class_1282 damageSource) {
        return FOTSoundEvents.ISLEHOPPER_HURT;
    }

    protected class_3414 method_6457() {
        return FOTSoundEvents.ISLEHOPPER_FLOP;
    }

    public boolean method_5698(class_1297 entity) {
        int multiplier;
        int n = multiplier = this.isTrophy() ? 2 : 1;
        if (entity instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)entity;
            if (entity.method_5643(class_1282.method_5511((class_1309)this), (float)multiplier)) {
                if (!this.method_5701()) {
                    serverPlayer.field_13987.method_14364((class_2596)new class_2668(class_2668.field_25654, 0.0f));
                }
                serverPlayer.method_37222(new class_1293(class_1294.field_5899, 60 * multiplier, 0), (class_1297)this);
            }
        }
        return false;
    }

    public class_4048 method_18377(class_4050 pose) {
        return this.isTrophy() ? super.method_18377(pose) : class_4048.method_18385((float)0.3f, (float)0.2f);
    }

    protected float method_18394(class_4050 pose, class_4048 size) {
        return this.isTrophy() ? 0.29f : 0.15f;
    }

    @Override
    public boolean canGlow() {
        return this.getVariant() == Variant.AMETHYST;
    }

    @Override
    public float getGlowBrightness(float ageInTicks) {
        return class_3532.method_15363((float)(1.0f + class_3532.method_15362((float)(ageInTicks * 0.05f))), (float)0.5f, (float)1.0f);
    }

    @Override
    public Variant getVariant() {
        return Variant.BY_ID[class_3532.method_15387((int)((Integer)this.field_6011.method_12789(TYPE)), (int)Variant.BY_ID.length)];
    }

    @Override
    public int getSpawnVariantId(boolean bucket) {
        return ThievesFish.getSpawnVariant((class_1309)this, Variant.BY_ID, Variant[]::new, bucket);
    }

    @Override
    public boolean isFood(class_1799 itemStack) {
        return WORMS.method_8093(itemStack);
    }

    @Override
    public Map<FishVariant, class_2960> getGlowTextureByType() {
        return GLOW_BY_TYPE;
    }

    public static boolean checkSpawnRules(class_1299<? extends class_1480> entityType, class_1936 level, class_3730 mobSpawnType, class_2338 blockPos, Random random) {
        boolean isSurfaceWater = class_1480.method_38986(entityType, (class_1936)level, (class_3730)mobSpawnType, (class_2338)blockPos, (Random)random);
        boolean isWater = level.method_8316(blockPos.method_10074()).method_15767(class_3486.field_15517) && level.method_8320(blockPos.method_10084()).method_27852(class_2246.field_10382);
        class_6880 biome = level.method_23753(blockPos);
        Continentalness continentalness = TerrainUtils.getContinentalness((class_3218)level, blockPos);
        PeakTypes peakTypes = TerrainUtils.getPeakTypes((class_3218)level, blockPos);
        if (biome.method_40220(class_6908.field_36509) || biome.method_40220(class_6908.field_36510)) {
            return !(!isSurfaceWater || peakTypes != PeakTypes.LOW && peakTypes != PeakTypes.MID || continentalness != Continentalness.COAST && continentalness != Continentalness.OCEAN);
        }
        return isWater && biome.method_40220(FOTTags.IS_CAVES) && blockPos.method_10264() <= 0;
    }

    public static enum Variant implements FishVariant
    {
        STONE(SpawnSelectors.always()),
        MOSS(SpawnSelectors.simpleSpawn(SpawnSelectors.biomeTag(FOTTags.SPAWNS_MOSS_ISLEHOPPERS))),
        HONEY(SpawnSelectors.simpleSpawn(context -> {
            class_4153 poiManager = context.level().method_19494();
            Optional optional = poiManager.method_20006(type -> type == class_4158.field_20351 || type == class_4158.field_20352, context.blockPos(), 9, class_4153.class_4155.field_18489);
            if (optional.isPresent()) {
                class_2680 blockState = context.level().method_8320((class_2338)optional.get());
                return class_4482.method_23902((class_2680)blockState) == 5;
            }
            return false;
        })),
        RAVEN(SpawnSelectors.simpleSpawn(FishOfThieves.CONFIG.spawnRate.ravenIslehopperProbability, SpawnSelectors.probability(FishOfThieves.CONFIG.spawnRate.ravenIslehopperProbability).and(context -> context.blockPos().method_10264() <= 0))),
        AMETHYST(SpawnSelectors.simpleSpawn(true, context -> TerrainUtils.lookForBlocksWithSize(context.blockPos(), 2, 16, blockPos2 -> context.level().method_8320(blockPos2).method_26164(class_3481.field_26986))));

        public static final Variant[] BY_ID;
        private final Predicate<SpawnConditionContext> condition;

        private Variant(Predicate<SpawnConditionContext> condition) {
            this.condition = condition;
        }

        @Override
        public String getName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        @Override
        public int getId() {
            return this.ordinal();
        }

        @Override
        public Predicate<SpawnConditionContext> getCondition() {
            return this.condition;
        }

        static {
            BY_ID = (Variant[])Stream.of(Variant.values()).sorted(Comparator.comparingInt(Variant::getId)).toArray(Variant[]::new);
        }
    }
}

