/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.entity.animal;

import com.stevekung.fishofthieves.core.FishOfThieves;
import com.stevekung.fishofthieves.entity.AbstractSchoolingThievesFish;
import com.stevekung.fishofthieves.entity.FishVariant;
import com.stevekung.fishofthieves.entity.ThievesFish;
import com.stevekung.fishofthieves.registry.FOTItems;
import com.stevekung.fishofthieves.registry.FOTSoundEvents;
import com.stevekung.fishofthieves.spawn.SpawnConditionContext;
import com.stevekung.fishofthieves.spawn.SpawnSelectors;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1391;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_4048;
import net.minecraft.class_4050;

public class Pondie
extends AbstractSchoolingThievesFish {
    private static final Map<FishVariant, class_2960> GLOW_BY_TYPE = Collections.singletonMap(Variant.MOONSKY, new class_2960("fishofthieves", "textures/entity/pondie/moonsky_glow.png"));

    public Pondie(class_1299<? extends Pondie> entityType, class_1937 level) {
        super(entityType, level);
    }

    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(3, (class_1352)new class_1391((class_1314)this, 1.25, WORMS, false));
    }

    public class_1799 method_6452() {
        return new class_1799((class_1935)FOTItems.PONDIE_BUCKET);
    }

    protected class_3414 method_6002() {
        return FOTSoundEvents.PONDIE_DEATH;
    }

    protected class_3414 method_6011(class_1282 damageSource) {
        return FOTSoundEvents.PONDIE_HURT;
    }

    protected class_3414 method_6457() {
        return FOTSoundEvents.PONDIE_FLOP;
    }

    public int method_6465() {
        return 5;
    }

    public class_4048 method_18377(class_4050 pose) {
        return this.isTrophy() ? super.method_18377(pose) : class_4048.method_18385((float)0.35f, (float)0.25f);
    }

    protected float method_18394(class_4050 pose, class_4048 size) {
        return this.isTrophy() ? 0.35f : 0.18f;
    }

    @Override
    public boolean canGlow() {
        return this.getVariant() == Variant.MOONSKY;
    }

    @Override
    public Variant getVariant() {
        return Variant.BY_ID[class_3532.method_15387((int)((Integer)this.field_6011.method_12789(TYPE)), (int)Variant.BY_ID.length)];
    }

    @Override
    public int getSpawnVariantId(boolean bucket) {
        return ThievesFish.getSpawnVariant((class_1309)this, Variant.BY_ID, Variant[]::new, bucket);
    }

    @Override
    public boolean isFood(class_1799 itemStack) {
        return WORMS.method_8093(itemStack);
    }

    @Override
    public Map<FishVariant, class_2960> getGlowTextureByType() {
        return GLOW_BY_TYPE;
    }

    public static enum Variant implements FishVariant
    {
        CHARCOAL(SpawnSelectors.always()),
        ORCHID(SpawnSelectors.always()),
        BRONZE(SpawnSelectors.always()),
        BRIGHT(SpawnSelectors.simpleSpawn(FishOfThieves.CONFIG.spawnRate.brightPondieProbability, SpawnSelectors.probability(FishOfThieves.CONFIG.spawnRate.brightPondieProbability).and(SpawnSelectors.dayAndSeeSky()))),
        MOONSKY(SpawnSelectors.nightAndSeeSky());

        public static final Variant[] BY_ID;
        private final Predicate<SpawnConditionContext> condition;

        private Variant(Predicate<SpawnConditionContext> condition) {
            this.condition = condition;
        }

        @Override
        public String getName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        @Override
        public int getId() {
            return this.ordinal();
        }

        @Override
        public Predicate<SpawnConditionContext> getCondition() {
            return this.condition;
        }

        static {
            BY_ID = (Variant[])Stream.of(Variant.values()).sorted(Comparator.comparingInt(Variant::getId)).toArray(Variant[]::new);
        }
    }
}

