/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.entity.animal;

import com.stevekung.fishofthieves.core.FishOfThieves;
import com.stevekung.fishofthieves.entity.AbstractSchoolingThievesFish;
import com.stevekung.fishofthieves.entity.FishVariant;
import com.stevekung.fishofthieves.entity.ThievesFish;
import com.stevekung.fishofthieves.registry.FOTItems;
import com.stevekung.fishofthieves.registry.FOTSoundEvents;
import com.stevekung.fishofthieves.registry.FOTTags;
import com.stevekung.fishofthieves.spawn.SpawnConditionContext;
import com.stevekung.fishofthieves.spawn.SpawnSelectors;
import com.stevekung.fishofthieves.utils.Continentalness;
import com.stevekung.fishofthieves.utils.TerrainUtils;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1391;
import net.minecraft.class_1480;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3481;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_6880;

public class Wildsplash
extends AbstractSchoolingThievesFish {
    private static final Map<FishVariant, class_2960> GLOW_BY_TYPE = Collections.singletonMap(Variant.CORAL, new class_2960("fishofthieves", "textures/entity/wildsplash/coral_glow.png"));

    public Wildsplash(class_1299<? extends Wildsplash> entityType, class_1937 level) {
        super(entityType, level);
    }

    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(3, (class_1352)new class_1391((class_1314)this, 1.25, EARTHWORMS_FOOD, false));
    }

    public class_1799 method_6452() {
        return new class_1799((class_1935)FOTItems.WILDSPLASH_BUCKET);
    }

    protected class_3414 method_6002() {
        return FOTSoundEvents.WILDSPLASH_DEATH;
    }

    protected class_3414 method_6011(class_1282 damageSource) {
        return FOTSoundEvents.WILDSPLASH_HURT;
    }

    protected class_3414 method_6457() {
        return FOTSoundEvents.WILDSPLASH_FLOP;
    }

    public int method_6465() {
        return 4;
    }

    public class_4048 method_18377(class_4050 pose) {
        return this.isTrophy() ? super.method_18377(pose) : class_4048.method_18385((float)0.3f, (float)0.25f);
    }

    protected float method_18394(class_4050 pose, class_4048 size) {
        return this.isTrophy() ? 0.38f : 0.2f;
    }

    @Override
    public boolean canGlow() {
        return this.getVariant() == Variant.CORAL;
    }

    @Override
    public Variant getVariant() {
        return Variant.BY_ID[class_3532.method_15387((int)((Integer)this.field_6011.method_12789(TYPE)), (int)Variant.BY_ID.length)];
    }

    @Override
    public int getSpawnVariantId(boolean bucket) {
        return ThievesFish.getSpawnVariant((class_1309)this, Variant.BY_ID, Variant[]::new, bucket);
    }

    @Override
    public boolean isFood(class_1799 itemStack) {
        return EARTHWORMS_FOOD.method_8093(itemStack);
    }

    @Override
    public Map<FishVariant, class_2960> getGlowTextureByType() {
        return GLOW_BY_TYPE;
    }

    public static boolean checkSpawnRules(class_1299<? extends class_1480> entityType, class_1936 level, class_3730 mobSpawnType, class_2338 blockPos, Random random) {
        boolean isSurfaceWater = class_1480.method_38986(entityType, (class_1936)level, (class_3730)mobSpawnType, (class_2338)blockPos, (Random)random);
        boolean isWater = level.method_8316(blockPos.method_10074()).method_15767(class_3486.field_15517) && level.method_8320(blockPos.method_10084()).method_27852(class_2246.field_10382);
        class_6880 biome = level.method_23753(blockPos);
        return isWater && biome.method_40220(FOTTags.SPAWNS_WILDSPLASH) || isSurfaceWater;
    }

    public static enum Variant implements FishVariant
    {
        RUSSET(SpawnSelectors.always()),
        SANDY(SpawnSelectors.simpleSpawn(SpawnSelectors.biomeTag(FOTTags.SPAWNS_SANDY_WILDSPLASH).and(SpawnSelectors.continentalness(Continentalness.COAST)))),
        OCEAN(SpawnSelectors.simpleSpawn(SpawnSelectors.biomeTag(FOTTags.SPAWNS_OCEAN_WILDSPLASH))),
        MUDDY(SpawnSelectors.simpleSpawn(FishOfThieves.CONFIG.spawnRate.muddyWildsplashProbability, SpawnSelectors.probability(FishOfThieves.CONFIG.spawnRate.muddyWildsplashProbability).and(SpawnSelectors.biomeTag(FOTTags.SPAWNS_CORAL_WILDSPLASH)))),
        CORAL(SpawnSelectors.simpleSpawn(true, SpawnSelectors.nightAndSeeSky().and(SpawnSelectors.biomeTag(FOTTags.SPAWNS_CORAL_WILDSPLASH)).and(context -> TerrainUtils.lookForBlocksWithSize(context.blockPos(), 3, 24, blockPos2 -> {
            class_2680 blockState = context.level().method_8320(blockPos2);
            return blockState.method_26164(class_3481.field_15488) || blockState.method_26164(class_3481.field_15461) || blockState.method_26164(class_3481.field_15476);
        }))));

        public static final Variant[] BY_ID;
        private final Predicate<SpawnConditionContext> condition;

        private Variant(Predicate<SpawnConditionContext> condition) {
            this.condition = condition;
        }

        @Override
        public String getName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        @Override
        public int getId() {
            return this.ordinal();
        }

        @Override
        public Predicate<SpawnConditionContext> getCondition() {
            return this.condition;
        }

        static {
            BY_ID = (Variant[])Stream.of(Variant.values()).sorted(Comparator.comparingInt(Variant::getId)).toArray(Variant[]::new);
        }
    }
}

