/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.entity.animal;

import com.google.common.collect.Maps;
import com.stevekung.fishofthieves.core.FishOfThieves;
import com.stevekung.fishofthieves.entity.AbstractThievesFish;
import com.stevekung.fishofthieves.entity.FishVariant;
import com.stevekung.fishofthieves.entity.ThievesFish;
import com.stevekung.fishofthieves.registry.FOTItems;
import com.stevekung.fishofthieves.registry.FOTSoundEvents;
import com.stevekung.fishofthieves.registry.FOTTags;
import com.stevekung.fishofthieves.spawn.SpawnConditionContext;
import com.stevekung.fishofthieves.spawn.SpawnSelectors;
import com.stevekung.fishofthieves.utils.TerrainUtils;
import java.util.Comparator;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1352;
import net.minecraft.class_1366;
import net.minecraft.class_1379;
import net.minecraft.class_1391;
import net.minecraft.class_1400;
import net.minecraft.class_1480;
import net.minecraft.class_156;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5534;
import net.minecraft.class_7045;
import net.minecraft.class_7058;
import org.jetbrains.annotations.Nullable;

public class Wrecker
extends AbstractThievesFish {
    private static final Map<FishVariant, class_2960> GLOW_BY_TYPE = (Map)class_156.method_654((Object)Maps.newHashMap(), map -> {
        map.put(Variant.SUN, new class_2960("fishofthieves", "textures/entity/wrecker/sun_glow.png"));
        map.put(Variant.BLACKCLOUD, new class_2960("fishofthieves", "textures/entity/wrecker/blackcloud_glow.png"));
        map.put(Variant.SNOW, new class_2960("fishofthieves", "textures/entity/wrecker/snow_glow.png"));
        map.put(Variant.MOON, new class_2960("fishofthieves", "textures/entity/wrecker/moon_glow.png"));
    });
    private static final Predicate<class_1309> SELECTORS = livingEntity -> livingEntity.method_6046() != class_1310.field_6292 && livingEntity.method_5799() && livingEntity.method_6102();

    public Wrecker(class_1299<? extends Wrecker> entityType, class_1937 level) {
        super(entityType, level);
    }

    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(1, (class_1352)new class_1366((class_1314)this, 2.0, true));
        this.field_6201.method_6277(2, (class_1352)new SwimToNearbyWreckageGoal(this, 1.25));
        this.field_6201.method_6277(3, (class_1352)new class_1391((class_1314)this, 1.25, EARTHWORMS_FOOD, false));
        this.field_6185.method_6277(4, (class_1352)new class_1400((class_1308)this, class_1588.class, 20, true, false, SELECTORS));
        this.field_6185.method_6277(5, (class_1352)new class_1400((class_1308)this, class_1657.class, 50, true, false, SELECTORS));
    }

    public class_1799 method_6452() {
        return new class_1799((class_1935)FOTItems.WRECKER_BUCKET);
    }

    protected class_3414 method_6002() {
        return FOTSoundEvents.WRECKER_DEATH;
    }

    protected class_3414 method_6011(class_1282 damageSource) {
        return FOTSoundEvents.WRECKER_HURT;
    }

    protected class_3414 method_6457() {
        return FOTSoundEvents.WRECKER_FLOP;
    }

    public class_4048 method_18377(class_4050 pose) {
        return this.isTrophy() ? super.method_18377(pose) : class_4048.method_18385((float)0.275f, (float)0.25f);
    }

    protected float method_18394(class_4050 pose, class_4048 size) {
        return this.isTrophy() ? 0.35f : 0.175f;
    }

    @Override
    @Nullable
    public class_1315 method_5943(class_5425 level, class_1266 difficulty, class_3730 reason, @Nullable class_1315 spawnData, @Nullable class_2487 dataTag) {
        spawnData = super.method_5943(level, difficulty, reason, spawnData, dataTag);
        if (this.isTrophy()) {
            this.method_5996(class_5134.field_23721).method_6192(2.5);
        }
        return spawnData;
    }

    @Override
    public void setTrophy(boolean trophy) {
        if (trophy) {
            this.method_5996(class_5134.field_23721).method_6192(2.5);
        }
        super.setTrophy(trophy);
    }

    @Override
    public boolean isFood(class_1799 itemStack) {
        return EARTHWORMS_FOOD.method_8093(itemStack);
    }

    @Override
    public boolean canGlow() {
        return this.getVariant() != Variant.ROSE;
    }

    @Override
    public Variant getVariant() {
        return Variant.BY_ID[class_3532.method_15387((int)((Integer)this.field_6011.method_12789(TYPE)), (int)Variant.BY_ID.length)];
    }

    @Override
    public int getSpawnVariantId(boolean bucket) {
        return ThievesFish.getSpawnVariant((class_1309)this, Variant.BY_ID, Variant[]::new, bucket);
    }

    @Override
    public Map<FishVariant, class_2960> getGlowTextureByType() {
        return GLOW_BY_TYPE;
    }

    public static boolean checkSpawnRules(class_1299<? extends class_1480> entityType, class_1936 level, class_3730 mobSpawnType, class_2338 blockPos, Random random) {
        boolean isWater = level.method_8320(blockPos).method_27852(class_2246.field_10382);
        return isWater && (TerrainUtils.isInFeature((class_3218)level, blockPos, class_7058.field_37175) || TerrainUtils.isInFeature((class_3218)level, blockPos, class_7058.field_37166));
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 3.0).method_26868(class_5134.field_23717, 10.0).method_26868(class_5134.field_23721, 1.5).method_26868(class_5134.field_23722, 0.01);
    }

    static class SwimToNearbyWreckageGoal
    extends class_1379 {
        SwimToNearbyWreckageGoal(Wrecker wrecker, double speedModifier) {
            super((class_1314)wrecker, speedModifier);
        }

        @Nullable
        protected class_243 method_6302() {
            class_2338 shipwreckPos = ((class_3218)this.field_6566.field_6002).method_8487(class_7045.field_37047, this.field_6566.method_24515(), 32, false);
            class_2338 ruinedPortalPos = ((class_3218)this.field_6566.field_6002).method_8487(class_7045.field_37048, this.field_6566.method_24515(), 32, false);
            if (this.field_6566.field_6002.field_9229.nextFloat() < 0.3f) {
                return class_5534.method_31527((class_1314)this.field_6566, (int)10, (int)7);
            }
            if (shipwreckPos != null) {
                return class_243.method_24953((class_2382)shipwreckPos);
            }
            if (ruinedPortalPos != null) {
                return class_243.method_24953((class_2382)ruinedPortalPos);
            }
            return super.method_6302();
        }
    }

    public static enum Variant implements FishVariant
    {
        ROSE(SpawnSelectors.always()),
        SUN(SpawnSelectors.simpleSpawn(SpawnSelectors.dayAndSeeSky())),
        BLACKCLOUD(SpawnSelectors.thunderingAndSeeSky()),
        SNOW(SpawnSelectors.simpleSpawn(FishOfThieves.CONFIG.spawnRate.snowWreckerProbability, SpawnSelectors.probability(FishOfThieves.CONFIG.spawnRate.snowWreckerProbability).and(SpawnSelectors.biomeTag(FOTTags.SPAWNS_SNOW_WRECKERS)))),
        MOON(SpawnSelectors.simpleSpawn(true, SpawnSelectors.nightAndSeeSky().and(context -> context.level().method_30272() > 0.0f)));

        public static final Variant[] BY_ID;
        private final Predicate<SpawnConditionContext> condition;

        private Variant(Predicate<SpawnConditionContext> condition) {
            this.condition = condition;
        }

        @Override
        public String getName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        @Override
        public int getId() {
            return this.ordinal();
        }

        @Override
        public Predicate<SpawnConditionContext> getCondition() {
            return this.condition;
        }

        static {
            BY_ID = (Variant[])Stream.of(Variant.values()).sorted(Comparator.comparingInt(Variant::getId)).toArray(Variant[]::new);
        }
    }
}

