/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.predicates;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.stevekung.fishofthieves.utils.Continentalness;
import com.stevekung.fishofthieves.utils.TerrainUtils;
import java.util.Iterator;
import java.util.Optional;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3518;
import net.minecraft.class_5312;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import org.jetbrains.annotations.Nullable;

public record FOTLocationPredicate(class_6862<class_1959> biome, class_6862<class_5312<?, ?>> structure, Continentalness continentalness, Boolean hasRaids) {
    public static final FOTLocationPredicate ANY = new FOTLocationPredicate(null, null, null, null);

    public boolean matches(class_3218 level, double x, double y, double z) {
        class_2338 blockPos = new class_2338(x, y, z);
        boolean loaded = level.method_8477(blockPos);
        boolean isRaided = level.method_19503(blockPos);
        Optional structureFeatureHolderSet = level.method_30349().method_30530(class_2378.field_25915).method_40266(this.structure);
        return (this.biome == null || loaded && level.method_23753(blockPos).method_40220(this.biome)) && (this.structure == null || structureFeatureHolderSet.isEmpty() || structureFeatureHolderSet.isPresent() && loaded && this.structureMatched(level, blockPos, (class_6885.class_6888)structureFeatureHolderSet.get())) && (this.continentalness == null || loaded && this.continentalness == TerrainUtils.getContinentalness(level, blockPos)) && (this.hasRaids == null || loaded && this.hasRaids == isRaided);
    }

    private boolean structureMatched(class_3218 level, class_2338 blockPos, class_6885.class_6888<class_5312<?, ?>> holders) {
        Iterator iterator = holders.iterator();
        if (iterator.hasNext()) {
            class_6880 holder = (class_6880)iterator.next();
            return level.method_27056().method_38854(blockPos, (class_5312)holder.comp_349()).method_16657();
        }
        return false;
    }

    public JsonElement serializeToJson() {
        if (this == ANY) {
            return JsonNull.INSTANCE;
        }
        JsonObject jsonObject = new JsonObject();
        if (this.biome != null) {
            jsonObject.addProperty("biome", this.biome.comp_327().toString());
        }
        if (this.structure != null) {
            jsonObject.addProperty("structure", this.structure.comp_327().toString());
        }
        if (this.continentalness != null) {
            jsonObject.addProperty("continentalness", this.continentalness.method_15434());
        }
        if (this.hasRaids != null) {
            jsonObject.addProperty("hasRaids", this.hasRaids);
        }
        return jsonObject;
    }

    public static FOTLocationPredicate fromJson(@Nullable JsonElement json) {
        String string;
        if (json == null || json.isJsonNull()) {
            return ANY;
        }
        JsonObject jsonObject = class_3518.method_15295((JsonElement)json, (String)"location");
        class_6862 biome = null;
        class_6862 structure = null;
        Continentalness continentalness = null;
        Boolean hasRaids = null;
        if (jsonObject.has("biome")) {
            string = class_3518.method_15265((JsonObject)jsonObject, (String)"biome");
            biome = class_6862.method_40092((class_5321)class_2378.field_25114, (class_2960)new class_2960(string));
        }
        if (jsonObject.has("structure")) {
            string = class_3518.method_15265((JsonObject)jsonObject, (String)"structure");
            structure = class_6862.method_40092((class_5321)class_2378.field_25915, (class_2960)new class_2960(string));
        }
        if (jsonObject.has("continentalness")) {
            continentalness = Continentalness.byName(class_3518.method_15265((JsonObject)jsonObject, (String)"continentalness"));
        }
        if (jsonObject.has("hasRaids")) {
            hasRaids = class_3518.method_15270((JsonObject)jsonObject, (String)"hasRaids");
        }
        return new FOTLocationPredicate((class_6862<class_1959>)biome, structure, continentalness, hasRaids);
    }

    public static class Builder {
        @Nullable
        private class_6862<class_1959> biome;
        @Nullable
        private class_6862<class_5312<?, ?>> structure;
        @Nullable
        private Continentalness continentalness;
        @Nullable
        private Boolean hasRaids;

        public static Builder location() {
            return new Builder();
        }

        public Builder setBiome(@Nullable class_6862<class_1959> biome) {
            this.biome = biome;
            return this;
        }

        public Builder setStructure(@Nullable class_6862<class_5312<?, ?>> structure) {
            this.structure = structure;
            return this;
        }

        public Builder setContinentalness(@Nullable Continentalness continentalness) {
            this.continentalness = continentalness;
            return this;
        }

        public Builder hasRaids() {
            this.hasRaids = true;
            return this;
        }

        public FOTLocationPredicate build() {
            return new FOTLocationPredicate(this.biome, this.structure, this.continentalness, this.hasRaids);
        }
    }
}

