/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.spawn;

import com.stevekung.fishofthieves.core.FishOfThieves;
import com.stevekung.fishofthieves.spawn.SpawnConditionContext;
import com.stevekung.fishofthieves.utils.Continentalness;
import com.stevekung.fishofthieves.utils.TerrainUtils;
import java.util.Collections;
import java.util.EnumSet;
import java.util.function.Predicate;
import net.minecraft.class_1309;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_5312;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;

public final class SpawnSelectors {
    public static Predicate<SpawnConditionContext> always() {
        return context -> true;
    }

    public static Predicate<SpawnConditionContext> dayAndSeeSky() {
        return context -> context.isDay() && context.seeSkyInWater();
    }

    public static Predicate<SpawnConditionContext> nightAndSeeSky() {
        return context -> context.isNight() && context.seeSkyInWater();
    }

    public static Predicate<SpawnConditionContext> rainingAndSeeSky() {
        return context -> context.isRaining() && context.seeSkyInWater();
    }

    public static Predicate<SpawnConditionContext> thunderingAndSeeSky() {
        return context -> context.isRaining() && context.isThundering() && context.seeSkyInWater();
    }

    public static Predicate<SpawnConditionContext> probability(float probability) {
        return context -> context.random().nextFloat() < probability;
    }

    public static Predicate<SpawnConditionContext> simpleSpawn(Predicate<SpawnConditionContext> complex) {
        return SpawnSelectors.simpleSpawn(false, complex);
    }

    public static Predicate<SpawnConditionContext> simpleSpawn(boolean nightTime, Predicate<SpawnConditionContext> complex) {
        return FishOfThieves.CONFIG.general.simpleSpawningCondition ? (nightTime ? SpawnSelectors.nightAndSeeSky() : SpawnSelectors.always()) : complex;
    }

    public static Predicate<SpawnConditionContext> simpleSpawn(float probability, Predicate<SpawnConditionContext> complex) {
        return FishOfThieves.CONFIG.general.simpleSpawningCondition ? SpawnSelectors.probability(probability) : complex;
    }

    @SafeVarargs
    public static Predicate<SpawnConditionContext> features(class_5321<class_5312<?, ?>> ... structureFeatures) {
        return context -> {
            for (class_5321 structureFeature : structureFeatures) {
                if (!TerrainUtils.isInFeature(context.level(), context.blockPos(), structureFeature)) continue;
                return true;
            }
            return false;
        };
    }

    public static Predicate<SpawnConditionContext> biomeTag(class_6862<class_1959> tagKey) {
        return context -> context.level().method_23753(context.blockPos()).method_40220(tagKey);
    }

    public static Predicate<SpawnConditionContext> continentalness(Continentalness ... continentalnesses) {
        EnumSet<Continentalness> continentalnessSet = EnumSet.noneOf(Continentalness.class);
        Collections.addAll(continentalnessSet, continentalnesses);
        return context -> continentalnessSet.stream().anyMatch(continentalness -> context.continentalness() == continentalness);
    }

    public static SpawnConditionContext get(class_1309 livingEntity) {
        class_3218 level = (class_3218)livingEntity.field_6002;
        class_2338 blockPos = livingEntity.method_24515();
        return new SpawnConditionContext(level, blockPos, livingEntity.method_6051(), level.method_8530(), level.method_23886(), level.method_8419(), level.method_8546(), level.method_22348(blockPos), (class_6880<class_1959>)level.method_23753(blockPos), TerrainUtils.getContinentalness(level, blockPos));
    }
}

