/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.stevekung.fishofthieves.client.model.HeadphoneModel;
import com.stevekung.fishofthieves.entity.AbstractSchoolingThievesFish;
import com.stevekung.fishofthieves.entity.animal.Pondie;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class PondieModel<T extends Pondie>
extends EntityModel<T>
implements HeadphoneModel.Scaleable<T> {
    public static final ModelLayerLocation LAYER = new ModelLayerLocation(new ResourceLocation("fishofthieves", "pondie"), "main");
    private final ModelPart head;
    private final ModelPart mouth;
    private final ModelPart body_main;
    private final ModelPart body_back;

    public PondieModel(ModelPart part) {
        super(RenderType::m_110452_);
        this.head = part.m_171324_("head");
        this.mouth = this.head.m_171324_("mouth_r1");
        this.body_main = part.m_171324_("body_main");
        this.body_back = part.m_171324_("body_back");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.m_171576_();
        PartDefinition head = partDefinition.m_171599_("head", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        head.m_171599_("mouth_r1", CubeListBuilder.m_171558_().m_171514_(0, 20).m_171488_(-2.5f, 0.025f, -5.05f, 5.0f, 1.0f, 5.0f, new CubeDeformation(0.02f)), PartPose.m_171423_((float)0.0f, (float)-1.15f, (float)-3.0f, (float)-0.8727f, (float)0.0f, (float)0.0f));
        head.m_171599_("head_r1", CubeListBuilder.m_171558_().m_171514_(0, 11).m_171488_(-2.5f, -2.19f, -2.3f, 5.0f, 5.0f, 4.0f, new CubeDeformation(0.01f)), PartPose.m_171423_((float)0.0f, (float)-4.26f, (float)-3.0f, (float)0.48f, (float)0.0f, (float)0.0f));
        PartDefinition body_main = partDefinition.m_171599_("body_main", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.5f, -7.0f, -2.5f, 5.0f, 6.0f, 5.0f, CubeDeformation.f_171458_).m_171514_(15, 0).m_171488_(-2.5f, -2.0f, -3.5f, 5.0f, 1.0f, 1.0f, CubeDeformation.f_171458_).m_171514_(18, 18).m_171488_(0.0f, -8.5f, -2.0f, 0.0f, 2.0f, 4.0f, CubeDeformation.f_171458_).m_171514_(15, 1).m_171488_(0.0f, -1.0f, -2.0f, 0.0f, 1.0f, 3.0f, CubeDeformation.f_171458_), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        body_main.m_171599_("right_fin_r1", CubeListBuilder.m_171558_().m_171514_(24, 17).m_171488_(-3.5f, -5.0f, 0.5f, 3.0f, 3.0f, 0.0f, CubeDeformation.f_171458_), PartPose.m_171423_((float)-2.25f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.7854f, (float)0.0f));
        body_main.m_171599_("left_fin_r1", CubeListBuilder.m_171558_().m_171514_(18, 17).m_171488_(0.5f, -5.0f, 0.5f, 3.0f, 3.0f, 0.0f, CubeDeformation.f_171458_), PartPose.m_171423_((float)2.25f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        PartDefinition body_back = partDefinition.m_171599_("body_back", CubeListBuilder.m_171558_().m_171514_(20, 4).m_171488_(-1.5f, -2.0f, 0.0f, 3.0f, 4.0f, 2.0f, CubeDeformation.f_171458_).m_171514_(20, 10).m_171488_(-1.0f, -1.5f, 1.5f, 2.0f, 3.0f, 2.0f, CubeDeformation.f_171458_).m_171514_(0, 23).m_171488_(0.0f, -2.5f, 3.5f, 0.0f, 5.0f, 3.0f, CubeDeformation.f_171458_), PartPose.m_171419_((float)0.0f, (float)19.5f, (float)2.5f));
        body_back.m_171599_("right_fin_r2", CubeListBuilder.m_171558_().m_171514_(24, 17).m_171488_(0.75f, 1.3f, 3.0f, 0.0f, 2.0f, 3.0f, CubeDeformation.f_171458_), PartPose.m_171423_((float)-1.0f, (float)0.0f, (float)-2.5f, (float)0.0f, (float)0.0f, (float)0.5236f));
        body_back.m_171599_("left_fin_r2", CubeListBuilder.m_171558_().m_171514_(18, 17).m_171488_(-0.75f, 1.3f, 3.0f, 0.0f, 2.0f, 3.0f, CubeDeformation.f_171458_), PartPose.m_171423_((float)1.0f, (float)0.0f, (float)-2.5f, (float)0.0f, (float)0.0f, (float)-0.5236f));
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)32, (int)32);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float backRotation = 1.0f;
        float backRotSpeed = 1.0f;
        float mouthSpeed = 0.15f;
        if (!entity.m_20069_() && !((AbstractSchoolingThievesFish)entity).isNoFlip()) {
            backRotation = 1.5f;
            backRotSpeed = 1.7f;
            mouthSpeed = 2.1f;
        }
        this.body_back.f_104204_ = -backRotation * 0.15f * Mth.m_14031_((float)(backRotSpeed * 0.65f * ageInTicks));
        this.mouth.f_104203_ = -0.8727f + Mth.m_14089_((float)(mouthSpeed * ageInTicks)) * (float)Math.PI * 0.02f;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.head.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.body_main.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.body_back.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    @Override
    public void scale(T entity, PoseStack poseStack) {
        float scale = 2.0f;
        poseStack.m_85841_(scale, scale - 0.5f, scale - 0.5f);
        poseStack.m_85837_(0.0, (double)-0.3f, (double)-0.025f);
    }
}

