/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.client.renderer;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.stevekung.fishofthieves.client.renderer.entity.layers.GlowFishLayer;
import com.stevekung.fishofthieves.client.renderer.entity.layers.HeadphoneLayer;
import com.stevekung.fishofthieves.entity.FishVariant;
import com.stevekung.fishofthieves.entity.ThievesFish;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.animal.AbstractFish;

public abstract class ThievesFishRenderer<T extends AbstractFish, M extends EntityModel<T>>
extends MobRenderer<T, M> {
    protected ThievesFishRenderer(EntityRendererProvider.Context context, M entityModel) {
        super(context, entityModel, 0.2f);
        this.m_115326_(new GlowFishLayer(this));
        this.m_115326_(new HeadphoneLayer(this, context));
    }

    public ResourceLocation getTextureLocation(T livingEntity) {
        return this.getTextureMap().get(((ThievesFish)livingEntity).getVariant());
    }

    protected void scale(T livingEntity, PoseStack poseStack, float partialTickTime) {
        float scale = ((ThievesFish)livingEntity).isTrophy() ? 1.0f : 0.5f;
        poseStack.m_85841_(scale, scale, scale);
    }

    protected abstract Map<FishVariant, ResourceLocation> getTextureMap();

    protected static Map<FishVariant, ResourceLocation> createTextureByType(FishVariant[] variants, String name) {
        return (Map)Util.m_137469_((Object)Maps.newHashMap(), map -> map.putAll((Map)Stream.of(variants).collect(ImmutableMap.toImmutableMap(Function.identity(), variant -> new ResourceLocation("fishofthieves", "textures/entity/%s/%s.png".formatted(name, variant.getName()))))));
    }
}

