/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import com.stevekung.fishofthieves.client.model.SplashtailModel;
import com.stevekung.fishofthieves.client.renderer.ThievesFishRenderer;
import com.stevekung.fishofthieves.entity.FishVariant;
import com.stevekung.fishofthieves.entity.animal.Splashtail;
import java.util.Map;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

public class SplashtailRenderer
extends ThievesFishRenderer<Splashtail, SplashtailModel<Splashtail>> {
    private static final Map<FishVariant, ResourceLocation> TEXTURE_BY_TYPE = ThievesFishRenderer.createTextureByType(Splashtail.Variant.BY_ID, "splashtail");

    public SplashtailRenderer(EntityRendererProvider.Context context) {
        super(context, new SplashtailModel(context.m_174023_(SplashtailModel.LAYER)));
    }

    @Override
    protected Map<FishVariant, ResourceLocation> getTextureMap() {
        return TEXTURE_BY_TYPE;
    }

    protected void setupRotations(Splashtail entity, PoseStack poseStack, float ageInTicks, float rotationYaw, float partialTicks) {
        float bodyRotSpeed;
        float baseDegree;
        super.m_7523_((LivingEntity)entity, poseStack, ageInTicks, rotationYaw, partialTicks);
        boolean inWater = entity.m_20069_() || entity.isNoFlip();
        float bodyRotBase = 1.0f;
        float f = baseDegree = entity.isPartying() ? -20.0f : 4.0f;
        float f2 = entity.isPartying() ? (inWater ? 2.0f : 1.0f) : (bodyRotSpeed = 0.6f);
        if (!inWater) {
            bodyRotBase = 1.7f;
        }
        float degree = baseDegree * Mth.m_14031_((float)(bodyRotBase * bodyRotSpeed * ageInTicks));
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(degree));
        if (!inWater) {
            poseStack.m_85837_((double)0.15f, (double)0.1f, (double)-0.1f);
            poseStack.m_85845_(Vector3f.f_122227_.m_122240_(90.0f));
        }
    }
}

