/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.entity;

import com.stevekung.fishofthieves.core.FishOfThieves;
import com.stevekung.fishofthieves.entity.FishVariant;
import com.stevekung.fishofthieves.entity.GlowFish;
import com.stevekung.fishofthieves.entity.PartyFish;
import com.stevekung.fishofthieves.registry.FOTTags;
import com.stevekung.fishofthieves.spawn.SpawnSelectors;
import java.util.Random;
import java.util.function.IntFunction;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.Nullable;

public interface ThievesFish
extends GlowFish,
PartyFish {
    public static final Ingredient WORMS = Ingredient.m_204132_(FOTTags.WORMS);
    public static final Ingredient EARTHWORMS_FOOD = Ingredient.m_204132_(FOTTags.EARTHWORMS_FOOD);
    public static final Ingredient GRUBS_FOOD = Ingredient.m_204132_(FOTTags.GRUBS_FOOD);
    public static final Ingredient LEECHES_FOOD = Ingredient.m_204132_(FOTTags.LEECHES_FOOD);
    public static final String VARIANT_TAG = "Variant";
    public static final String TROPHY_TAG = "Trophy";
    public static final String HAS_FED_TAG = "HasFed";
    public static final String NAME_TAG = "Name";
    public static final String NO_FLIP = "NoFlip";

    public void setNoFlip(boolean var1);

    public boolean isNoFlip();

    public FishVariant getVariant();

    public int getSpawnVariantId(boolean var1);

    public void setVariant(int var1);

    public boolean isTrophy();

    public void setTrophy(boolean var1);

    public boolean hasFed();

    public void setHasFed(boolean var1);

    public boolean isFood(ItemStack var1);

    default public void saveToBucket(CompoundTag compound) {
        compound.m_128405_(VARIANT_TAG, this.getVariant().getId());
        compound.m_128379_(TROPHY_TAG, this.isTrophy());
        compound.m_128379_(HAS_FED_TAG, this.hasFed());
        compound.m_128359_(NAME_TAG, this.getVariant().getName());
    }

    default public void loadFromBucket(CompoundTag compound) {
        if (compound.m_128441_(VARIANT_TAG)) {
            this.setVariant(compound.m_128451_(VARIANT_TAG));
        }
        if (compound.m_128441_(TROPHY_TAG)) {
            this.setTrophy(compound.m_128471_(TROPHY_TAG));
        }
        if (compound.m_128441_(HAS_FED_TAG)) {
            this.setHasFed(compound.m_128471_(HAS_FED_TAG));
        }
    }

    default public SpawnGroupData defaultFinalizeSpawn(LivingEntity livingEntity, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        if (reason == MobSpawnType.BUCKET && dataTag != null && dataTag.m_128425_(VARIANT_TAG, 3)) {
            this.setVariant(dataTag.m_128451_(VARIANT_TAG));
            this.setTrophy(dataTag.m_128471_(TROPHY_TAG));
            return spawnData;
        }
        if (livingEntity.m_21187_().nextFloat() < FishOfThieves.CONFIG.spawnRate.trophyProbability) {
            this.setTrophy(true);
            livingEntity.m_21153_(FishOfThieves.CONFIG.general.trophyMaxHealth);
        }
        this.setVariant(this.getSpawnVariantId(reason == MobSpawnType.BUCKET));
        return spawnData;
    }

    public static int getSpawnVariant(LivingEntity livingEntity, FishVariant[] ids, IntFunction<FishVariant[]> generator, boolean random) {
        Object[] variants = random ? (FishVariant[])Stream.of(ids).toArray(generator) : (FishVariant[])Stream.of(ids).filter(variant -> variant.getCondition().test(SpawnSelectors.get(livingEntity))).toArray(generator);
        return ((FishVariant)Util.m_137545_((Object[])variants, (Random)livingEntity.m_21187_())).getId();
    }
}

