/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.entity.animal;

import com.stevekung.fishofthieves.core.FishOfThieves;
import com.stevekung.fishofthieves.entity.AbstractSchoolingThievesFish;
import com.stevekung.fishofthieves.entity.FishVariant;
import com.stevekung.fishofthieves.entity.ThievesFish;
import com.stevekung.fishofthieves.registry.FOTItems;
import com.stevekung.fishofthieves.registry.FOTSoundEvents;
import com.stevekung.fishofthieves.spawn.SpawnConditionContext;
import com.stevekung.fishofthieves.spawn.SpawnSelectors;
import com.stevekung.fishofthieves.utils.TerrainUtils;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.structure.BuiltinStructures;

public class Ancientscale
extends AbstractSchoolingThievesFish {
    private static final Map<FishVariant, ResourceLocation> GLOW_BY_TYPE = Collections.singletonMap(Variant.STARSHINE, new ResourceLocation("fishofthieves", "textures/entity/ancientscale/starshine_glow.png"));

    public Ancientscale(EntityType<? extends Ancientscale> entityType, Level level) {
        super(entityType, level);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.25, LEECHES_FOOD, false));
    }

    public ItemStack m_142563_() {
        return new ItemStack((ItemLike)FOTItems.ANCIENTSCALE_BUCKET);
    }

    protected SoundEvent m_5592_() {
        return FOTSoundEvents.ANCIENTSCALE_DEATH;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return FOTSoundEvents.ANCIENTSCALE_HURT;
    }

    protected SoundEvent m_5699_() {
        return FOTSoundEvents.ANCIENTSCALE_FLOP;
    }

    public EntityDimensions m_6972_(Pose pose) {
        return this.isTrophy() ? super.m_6972_(pose) : EntityDimensions.m_20398_((float)0.3f, (float)0.25f);
    }

    protected float m_6431_(Pose pose, EntityDimensions size) {
        return this.isTrophy() ? 0.3575f : 0.18f;
    }

    @Override
    public boolean canGlow() {
        return this.getVariant() == Variant.STARSHINE;
    }

    @Override
    public Variant getVariant() {
        return Variant.BY_ID[Mth.m_14100_((int)((Integer)this.f_19804_.m_135370_(TYPE)), (int)Variant.BY_ID.length)];
    }

    @Override
    public int getSpawnVariantId(boolean bucket) {
        return ThievesFish.getSpawnVariant((LivingEntity)this, Variant.BY_ID, Variant[]::new, bucket);
    }

    @Override
    public boolean isFood(ItemStack itemStack) {
        return LEECHES_FOOD.test(itemStack);
    }

    @Override
    public Map<FishVariant, ResourceLocation> getGlowTextureByType() {
        return GLOW_BY_TYPE;
    }

    public static boolean checkSpawnRules(EntityType<? extends WaterAnimal> entityType, LevelAccessor level, MobSpawnType mobSpawnType, BlockPos blockPos, Random random) {
        boolean isSurfaceWater = WaterAnimal.m_186237_(entityType, (LevelAccessor)level, (MobSpawnType)mobSpawnType, (BlockPos)blockPos, (Random)random);
        boolean isWater = level.m_6425_(blockPos.m_7495_()).m_205070_(FluidTags.f_13131_) && level.m_8055_(blockPos.m_7494_()).m_60713_(Blocks.f_49990_);
        return isSurfaceWater || isWater && (TerrainUtils.isInFeature((ServerLevel)level, blockPos, BuiltinStructures.f_209846_) || TerrainUtils.isInFeature((ServerLevel)level, blockPos, BuiltinStructures.f_209855_));
    }

    public static enum Variant implements FishVariant
    {
        ALMOND(SpawnSelectors.always()),
        SAPPHIRE(SpawnSelectors.always()),
        SMOKE(SpawnSelectors.always()),
        BONE(SpawnSelectors.simpleSpawn(FishOfThieves.CONFIG.spawnRate.boneAncientscaleProbability, SpawnSelectors.probability(FishOfThieves.CONFIG.spawnRate.boneAncientscaleProbability).or(SpawnSelectors.features(BuiltinStructures.f_209846_, BuiltinStructures.f_209855_).and(context -> context.random().nextInt(10) == 0)))),
        STARSHINE(SpawnSelectors.simpleSpawn(true, SpawnSelectors.nightAndSeeSky().and(context -> context.level().m_46940_() <= 0.25f)));

        public static final Variant[] BY_ID;
        private final Predicate<SpawnConditionContext> condition;

        private Variant(Predicate<SpawnConditionContext> condition) {
            this.condition = condition;
        }

        @Override
        public String getName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        @Override
        public int getId() {
            return this.ordinal();
        }

        @Override
        public Predicate<SpawnConditionContext> getCondition() {
            return this.condition;
        }

        static {
            BY_ID = (Variant[])Stream.of(Variant.values()).sorted(Comparator.comparingInt(Variant::getId)).toArray(Variant[]::new);
        }
    }
}

