/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.entity.animal;

import com.stevekung.fishofthieves.core.FishOfThieves;
import com.stevekung.fishofthieves.entity.AbstractSchoolingThievesFish;
import com.stevekung.fishofthieves.entity.FishVariant;
import com.stevekung.fishofthieves.entity.ThievesFish;
import com.stevekung.fishofthieves.registry.FOTItems;
import com.stevekung.fishofthieves.registry.FOTSoundEvents;
import com.stevekung.fishofthieves.registry.FOTTags;
import com.stevekung.fishofthieves.spawn.SpawnConditionContext;
import com.stevekung.fishofthieves.spawn.SpawnSelectors;
import com.stevekung.fishofthieves.utils.TerrainUtils;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.structure.BuiltinStructures;
import org.jetbrains.annotations.Nullable;

public class Battlegill
extends AbstractSchoolingThievesFish {
    private static final Map<FishVariant, ResourceLocation> GLOW_BY_TYPE = Collections.singletonMap(Variant.BITTERSWEET, new ResourceLocation("fishofthieves", "textures/entity/battlegill/bittersweet_glow.png"));
    private static final Predicate<LivingEntity> SELECTORS = livingEntity -> livingEntity instanceof Enemy && (livingEntity.m_6336_() == MobType.f_21641_ || livingEntity.m_6336_() == MobType.f_21644_) && livingEntity.m_20069_() && livingEntity.m_5789_();

    public Battlegill(EntityType<? extends Battlegill> entityType, Level level) {
        super(entityType, level);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 2.0, true));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.25, GRUBS_FOOD, false));
        this.f_21346_.m_25352_(8, (Goal)new NearestAttackableTargetGoal((Mob)this, Monster.class, 20, true, false, SELECTORS));
    }

    public ItemStack m_142563_() {
        return new ItemStack((ItemLike)FOTItems.BATTLEGILL_BUCKET);
    }

    protected SoundEvent m_5592_() {
        return FOTSoundEvents.BATTLEGILL_DEATH;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return FOTSoundEvents.BATTLEGILL_HURT;
    }

    protected SoundEvent m_5699_() {
        return FOTSoundEvents.BATTLEGILL_FLOP;
    }

    public int m_6031_() {
        return 4;
    }

    public EntityDimensions m_6972_(Pose pose) {
        return this.isTrophy() ? super.m_6972_(pose) : EntityDimensions.m_20398_((float)0.275f, (float)0.275f);
    }

    protected float m_6431_(Pose pose, EntityDimensions size) {
        return this.isTrophy() ? 0.25f : 0.125f;
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        spawnData = super.m_6518_(level, difficulty, reason, spawnData, dataTag);
        if (this.isTrophy()) {
            this.m_21051_(Attributes.f_22281_).m_22100_(2.0);
        }
        return spawnData;
    }

    @Override
    public void setTrophy(boolean trophy) {
        if (trophy) {
            this.m_21051_(Attributes.f_22281_).m_22100_(2.0);
        }
        super.setTrophy(trophy);
    }

    @Override
    public boolean isFood(ItemStack itemStack) {
        return GRUBS_FOOD.test(itemStack);
    }

    @Override
    public boolean canGlow() {
        return this.getVariant() == Variant.BITTERSWEET;
    }

    @Override
    public Variant getVariant() {
        return Variant.BY_ID[Mth.m_14100_((int)((Integer)this.f_19804_.m_135370_(TYPE)), (int)Variant.BY_ID.length)];
    }

    @Override
    public int getSpawnVariantId(boolean bucket) {
        return ThievesFish.getSpawnVariant((LivingEntity)this, Variant.BY_ID, Variant[]::new, bucket);
    }

    @Override
    public Map<FishVariant, ResourceLocation> getGlowTextureByType() {
        return GLOW_BY_TYPE;
    }

    public static boolean checkSpawnRules(EntityType<? extends WaterAnimal> entityType, LevelAccessor level, MobSpawnType mobSpawnType, BlockPos blockPos, Random random) {
        boolean isWater = level.m_6425_(blockPos.m_7495_()).m_205070_(FluidTags.f_13131_) && level.m_8055_(blockPos.m_7494_()).m_60713_(Blocks.f_49990_);
        boolean isRaided = level.m_46861_(blockPos) && ((ServerLevel)level).m_8843_(blockPos);
        return isWater && (isRaided || TerrainUtils.isInFeature((ServerLevel)level, blockPos, BuiltinStructures.f_209856_) || TerrainUtils.isInFeature((ServerLevel)level, blockPos, BuiltinStructures.f_209845_));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 3.0).m_22268_(Attributes.f_22277_, 10.0).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22282_, 0.01);
    }

    public static enum Variant implements FishVariant
    {
        JADE(SpawnSelectors.always()),
        SKY(SpawnSelectors.simpleSpawn(SpawnConditionContext::seeSkyInWater)),
        RUM(SpawnSelectors.always()),
        SAND(SpawnSelectors.simpleSpawn(FishOfThieves.CONFIG.spawnRate.sandBattlegillProbability, SpawnSelectors.probability(FishOfThieves.CONFIG.spawnRate.sandBattlegillProbability).and(SpawnSelectors.biomeTag(FOTTags.SPAWNS_SAND_BATTLEGILLS)))),
        BITTERSWEET(SpawnSelectors.nightAndSeeSky());

        public static final Variant[] BY_ID;
        private final Predicate<SpawnConditionContext> condition;

        private Variant(Predicate<SpawnConditionContext> condition) {
            this.condition = condition;
        }

        @Override
        public String getName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        @Override
        public int getId() {
            return this.ordinal();
        }

        @Override
        public Predicate<SpawnConditionContext> getCondition() {
            return this.condition;
        }

        static {
            BY_ID = (Variant[])Stream.of(Variant.values()).sorted(Comparator.comparingInt(Variant::getId)).toArray(Variant[]::new);
        }
    }
}

