/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.entity.animal;

import com.stevekung.fishofthieves.core.FishOfThieves;
import com.stevekung.fishofthieves.entity.AbstractThievesFish;
import com.stevekung.fishofthieves.entity.FishVariant;
import com.stevekung.fishofthieves.entity.ThievesFish;
import com.stevekung.fishofthieves.registry.FOTItems;
import com.stevekung.fishofthieves.registry.FOTSoundEvents;
import com.stevekung.fishofthieves.registry.FOTTags;
import com.stevekung.fishofthieves.spawn.SpawnConditionContext;
import com.stevekung.fishofthieves.spawn.SpawnSelectors;
import com.stevekung.fishofthieves.utils.Continentalness;
import com.stevekung.fishofthieves.utils.PeakTypes;
import com.stevekung.fishofthieves.utils.TerrainUtils;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class Islehopper
extends AbstractThievesFish {
    private static final Map<FishVariant, ResourceLocation> GLOW_BY_TYPE = Collections.singletonMap(Variant.AMETHYST, new ResourceLocation("fishofthieves", "textures/entity/islehopper/amethyst_glow.png"));

    public Islehopper(EntityType<? extends Islehopper> entityType, Level level) {
        super(entityType, level);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.25, WORMS, false));
    }

    public ItemStack m_142563_() {
        return new ItemStack((ItemLike)FOTItems.ISLEHOPPER_BUCKET);
    }

    protected SoundEvent m_5592_() {
        return FOTSoundEvents.ISLEHOPPER_DEATH;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return FOTSoundEvents.ISLEHOPPER_HURT;
    }

    protected SoundEvent m_5699_() {
        return FOTSoundEvents.ISLEHOPPER_FLOP;
    }

    public boolean m_7313_(Entity entity) {
        int multiplier;
        int n = multiplier = this.isTrophy() ? 2 : 1;
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            if (entity.m_6469_(DamageSource.m_19370_((LivingEntity)this), (float)multiplier)) {
                if (!this.m_20067_()) {
                    serverPlayer.f_8906_.m_141995_((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.f_132162_, 0.0f));
                }
                serverPlayer.m_147207_(new MobEffectInstance(MobEffects.f_19614_, 60 * multiplier, 0), (Entity)this);
            }
        }
        return false;
    }

    public EntityDimensions m_6972_(Pose pose) {
        return this.isTrophy() ? super.m_6972_(pose) : EntityDimensions.m_20398_((float)0.3f, (float)0.2f);
    }

    protected float m_6431_(Pose pose, EntityDimensions size) {
        return this.isTrophy() ? 0.29f : 0.15f;
    }

    @Override
    public boolean canGlow() {
        return this.getVariant() == Variant.AMETHYST;
    }

    @Override
    public float getGlowBrightness(float ageInTicks) {
        return Mth.m_14036_((float)(1.0f + Mth.m_14089_((float)(ageInTicks * 0.05f))), (float)0.5f, (float)1.0f);
    }

    @Override
    public Variant getVariant() {
        return Variant.BY_ID[Mth.m_14100_((int)((Integer)this.f_19804_.m_135370_(TYPE)), (int)Variant.BY_ID.length)];
    }

    @Override
    public int getSpawnVariantId(boolean bucket) {
        return ThievesFish.getSpawnVariant((LivingEntity)this, Variant.BY_ID, Variant[]::new, bucket);
    }

    @Override
    public boolean isFood(ItemStack itemStack) {
        return WORMS.test(itemStack);
    }

    @Override
    public Map<FishVariant, ResourceLocation> getGlowTextureByType() {
        return GLOW_BY_TYPE;
    }

    public static boolean checkSpawnRules(EntityType<? extends WaterAnimal> entityType, LevelAccessor level, MobSpawnType mobSpawnType, BlockPos blockPos, Random random) {
        boolean isSurfaceWater = WaterAnimal.m_186237_(entityType, (LevelAccessor)level, (MobSpawnType)mobSpawnType, (BlockPos)blockPos, (Random)random);
        boolean isWater = level.m_6425_(blockPos.m_7495_()).m_205070_(FluidTags.f_13131_) && level.m_8055_(blockPos.m_7494_()).m_60713_(Blocks.f_49990_);
        Holder biome = level.m_204166_(blockPos);
        Continentalness continentalness = TerrainUtils.getContinentalness((ServerLevel)level, blockPos);
        PeakTypes peakTypes = TerrainUtils.getPeakTypes((ServerLevel)level, blockPos);
        if (biome.m_203656_(BiomeTags.f_207603_) || biome.m_203656_(BiomeTags.f_207604_)) {
            return !(!isSurfaceWater || peakTypes != PeakTypes.LOW && peakTypes != PeakTypes.MID || continentalness != Continentalness.COAST && continentalness != Continentalness.OCEAN);
        }
        return isWater && biome.m_203656_(FOTTags.IS_CAVES) && blockPos.m_123342_() <= 0;
    }

    public static enum Variant implements FishVariant
    {
        STONE(SpawnSelectors.always()),
        MOSS(SpawnSelectors.simpleSpawn(SpawnSelectors.biomeTag(FOTTags.SPAWNS_MOSS_ISLEHOPPERS))),
        HONEY(SpawnSelectors.simpleSpawn(context -> {
            PoiManager poiManager = context.level().m_8904_();
            Optional optional = poiManager.m_27192_(type -> type == PoiType.f_27348_ || type == PoiType.f_27349_, context.blockPos(), 9, PoiManager.Occupancy.ANY);
            if (optional.isPresent()) {
                BlockState blockState = context.level().m_8055_((BlockPos)optional.get());
                return BeehiveBlockEntity.m_58752_((BlockState)blockState) == 5;
            }
            return false;
        })),
        RAVEN(SpawnSelectors.simpleSpawn(FishOfThieves.CONFIG.spawnRate.ravenIslehopperProbability, SpawnSelectors.probability(FishOfThieves.CONFIG.spawnRate.ravenIslehopperProbability).and(context -> context.blockPos().m_123342_() <= 0))),
        AMETHYST(SpawnSelectors.simpleSpawn(true, context -> TerrainUtils.lookForBlocksWithSize(context.blockPos(), 2, 16, blockPos2 -> context.level().m_8055_(blockPos2).m_204336_(BlockTags.f_144270_))));

        public static final Variant[] BY_ID;
        private final Predicate<SpawnConditionContext> condition;

        private Variant(Predicate<SpawnConditionContext> condition) {
            this.condition = condition;
        }

        @Override
        public String getName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        @Override
        public int getId() {
            return this.ordinal();
        }

        @Override
        public Predicate<SpawnConditionContext> getCondition() {
            return this.condition;
        }

        static {
            BY_ID = (Variant[])Stream.of(Variant.values()).sorted(Comparator.comparingInt(Variant::getId)).toArray(Variant[]::new);
        }
    }
}

