/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.entity.animal;

import com.stevekung.fishofthieves.core.FishOfThieves;
import com.stevekung.fishofthieves.entity.AbstractSchoolingThievesFish;
import com.stevekung.fishofthieves.entity.FishVariant;
import com.stevekung.fishofthieves.entity.ThievesFish;
import com.stevekung.fishofthieves.registry.FOTItems;
import com.stevekung.fishofthieves.registry.FOTSoundEvents;
import com.stevekung.fishofthieves.spawn.SpawnConditionContext;
import com.stevekung.fishofthieves.spawn.SpawnSelectors;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class Pondie
extends AbstractSchoolingThievesFish {
    private static final Map<FishVariant, ResourceLocation> GLOW_BY_TYPE = Collections.singletonMap(Variant.MOONSKY, new ResourceLocation("fishofthieves", "textures/entity/pondie/moonsky_glow.png"));

    public Pondie(EntityType<? extends Pondie> entityType, Level level) {
        super(entityType, level);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.25, WORMS, false));
    }

    public ItemStack m_142563_() {
        return new ItemStack((ItemLike)FOTItems.PONDIE_BUCKET);
    }

    protected SoundEvent m_5592_() {
        return FOTSoundEvents.PONDIE_DEATH;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return FOTSoundEvents.PONDIE_HURT;
    }

    protected SoundEvent m_5699_() {
        return FOTSoundEvents.PONDIE_FLOP;
    }

    public int m_6031_() {
        return 5;
    }

    public EntityDimensions m_6972_(Pose pose) {
        return this.isTrophy() ? super.m_6972_(pose) : EntityDimensions.m_20398_((float)0.35f, (float)0.25f);
    }

    protected float m_6431_(Pose pose, EntityDimensions size) {
        return this.isTrophy() ? 0.35f : 0.18f;
    }

    @Override
    public boolean canGlow() {
        return this.getVariant() == Variant.MOONSKY;
    }

    @Override
    public Variant getVariant() {
        return Variant.BY_ID[Mth.m_14100_((int)((Integer)this.f_19804_.m_135370_(TYPE)), (int)Variant.BY_ID.length)];
    }

    @Override
    public int getSpawnVariantId(boolean bucket) {
        return ThievesFish.getSpawnVariant((LivingEntity)this, Variant.BY_ID, Variant[]::new, bucket);
    }

    @Override
    public boolean isFood(ItemStack itemStack) {
        return WORMS.test(itemStack);
    }

    @Override
    public Map<FishVariant, ResourceLocation> getGlowTextureByType() {
        return GLOW_BY_TYPE;
    }

    public static enum Variant implements FishVariant
    {
        CHARCOAL(SpawnSelectors.always()),
        ORCHID(SpawnSelectors.always()),
        BRONZE(SpawnSelectors.always()),
        BRIGHT(SpawnSelectors.simpleSpawn(FishOfThieves.CONFIG.spawnRate.brightPondieProbability, SpawnSelectors.probability(FishOfThieves.CONFIG.spawnRate.brightPondieProbability).and(SpawnSelectors.dayAndSeeSky()))),
        MOONSKY(SpawnSelectors.nightAndSeeSky());

        public static final Variant[] BY_ID;
        private final Predicate<SpawnConditionContext> condition;

        private Variant(Predicate<SpawnConditionContext> condition) {
            this.condition = condition;
        }

        @Override
        public String getName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        @Override
        public int getId() {
            return this.ordinal();
        }

        @Override
        public Predicate<SpawnConditionContext> getCondition() {
            return this.condition;
        }

        static {
            BY_ID = (Variant[])Stream.of(Variant.values()).sorted(Comparator.comparingInt(Variant::getId)).toArray(Variant[]::new);
        }
    }
}

