/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.entity.animal;

import com.google.common.collect.Maps;
import com.stevekung.fishofthieves.core.FishOfThieves;
import com.stevekung.fishofthieves.entity.AbstractThievesFish;
import com.stevekung.fishofthieves.entity.FishVariant;
import com.stevekung.fishofthieves.entity.ThievesFish;
import com.stevekung.fishofthieves.registry.FOTItems;
import com.stevekung.fishofthieves.registry.FOTSoundEvents;
import com.stevekung.fishofthieves.registry.FOTTags;
import com.stevekung.fishofthieves.spawn.SpawnConditionContext;
import com.stevekung.fishofthieves.spawn.SpawnSelectors;
import com.stevekung.fishofthieves.utils.TerrainUtils;
import java.util.Comparator;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.ConfiguredStructureTags;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.structure.BuiltinStructures;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Wrecker
extends AbstractThievesFish {
    private static final Map<FishVariant, ResourceLocation> GLOW_BY_TYPE = (Map)Util.m_137469_((Object)Maps.newHashMap(), map -> {
        map.put(Variant.SUN, new ResourceLocation("fishofthieves", "textures/entity/wrecker/sun_glow.png"));
        map.put(Variant.BLACKCLOUD, new ResourceLocation("fishofthieves", "textures/entity/wrecker/blackcloud_glow.png"));
        map.put(Variant.SNOW, new ResourceLocation("fishofthieves", "textures/entity/wrecker/snow_glow.png"));
        map.put(Variant.MOON, new ResourceLocation("fishofthieves", "textures/entity/wrecker/moon_glow.png"));
    });
    private static final Predicate<LivingEntity> SELECTORS = livingEntity -> livingEntity.m_6336_() != MobType.f_21644_ && livingEntity.m_20069_() && livingEntity.m_5789_();

    public Wrecker(EntityType<? extends Wrecker> entityType, Level level) {
        super(entityType, level);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 2.0, true));
        this.f_21345_.m_25352_(2, (Goal)new SwimToNearbyWreckageGoal(this, 1.25));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.25, EARTHWORMS_FOOD, false));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Monster.class, 20, true, false, SELECTORS));
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 50, true, false, SELECTORS));
    }

    public ItemStack m_142563_() {
        return new ItemStack((ItemLike)FOTItems.WRECKER_BUCKET);
    }

    protected SoundEvent m_5592_() {
        return FOTSoundEvents.WRECKER_DEATH;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return FOTSoundEvents.WRECKER_HURT;
    }

    protected SoundEvent m_5699_() {
        return FOTSoundEvents.WRECKER_FLOP;
    }

    public EntityDimensions m_6972_(Pose pose) {
        return this.isTrophy() ? super.m_6972_(pose) : EntityDimensions.m_20398_((float)0.275f, (float)0.25f);
    }

    protected float m_6431_(Pose pose, EntityDimensions size) {
        return this.isTrophy() ? 0.35f : 0.175f;
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        spawnData = super.m_6518_(level, difficulty, reason, spawnData, dataTag);
        if (this.isTrophy()) {
            this.m_21051_(Attributes.f_22281_).m_22100_(2.5);
        }
        return spawnData;
    }

    @Override
    public void setTrophy(boolean trophy) {
        if (trophy) {
            this.m_21051_(Attributes.f_22281_).m_22100_(2.5);
        }
        super.setTrophy(trophy);
    }

    @Override
    public boolean isFood(ItemStack itemStack) {
        return EARTHWORMS_FOOD.test(itemStack);
    }

    @Override
    public boolean canGlow() {
        return this.getVariant() != Variant.ROSE;
    }

    @Override
    public Variant getVariant() {
        return Variant.BY_ID[Mth.m_14100_((int)((Integer)this.f_19804_.m_135370_(TYPE)), (int)Variant.BY_ID.length)];
    }

    @Override
    public int getSpawnVariantId(boolean bucket) {
        return ThievesFish.getSpawnVariant((LivingEntity)this, Variant.BY_ID, Variant[]::new, bucket);
    }

    @Override
    public Map<FishVariant, ResourceLocation> getGlowTextureByType() {
        return GLOW_BY_TYPE;
    }

    public static boolean checkSpawnRules(EntityType<? extends WaterAnimal> entityType, LevelAccessor level, MobSpawnType mobSpawnType, BlockPos blockPos, Random random) {
        boolean isWater = level.m_8055_(blockPos).m_60713_(Blocks.f_49990_);
        return isWater && (TerrainUtils.isInFeature((ServerLevel)level, blockPos, BuiltinStructures.f_209852_) || TerrainUtils.isInFeature((ServerLevel)level, blockPos, BuiltinStructures.f_209843_));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 3.0).m_22268_(Attributes.f_22277_, 10.0).m_22268_(Attributes.f_22281_, 1.5).m_22268_(Attributes.f_22282_, 0.01);
    }

    static class SwimToNearbyWreckageGoal
    extends RandomStrollGoal {
        SwimToNearbyWreckageGoal(Wrecker wrecker, double speedModifier) {
            super((PathfinderMob)wrecker, speedModifier);
        }

        @Nullable
        protected Vec3 m_7037_() {
            BlockPos shipwreckPos = ((ServerLevel)this.f_25725_.f_19853_).m_207561_(ConfiguredStructureTags.f_207639_, this.f_25725_.m_142538_(), 32, false);
            BlockPos ruinedPortalPos = ((ServerLevel)this.f_25725_.f_19853_).m_207561_(ConfiguredStructureTags.f_207640_, this.f_25725_.m_142538_(), 32, false);
            if (this.f_25725_.f_19853_.f_46441_.nextFloat() < 0.3f) {
                return LandRandomPos.m_148488_((PathfinderMob)this.f_25725_, (int)10, (int)7);
            }
            if (shipwreckPos != null) {
                return Vec3.m_82512_((Vec3i)shipwreckPos);
            }
            if (ruinedPortalPos != null) {
                return Vec3.m_82512_((Vec3i)ruinedPortalPos);
            }
            return super.m_7037_();
        }
    }

    public static enum Variant implements FishVariant
    {
        ROSE(SpawnSelectors.always()),
        SUN(SpawnSelectors.simpleSpawn(SpawnSelectors.dayAndSeeSky())),
        BLACKCLOUD(SpawnSelectors.thunderingAndSeeSky()),
        SNOW(SpawnSelectors.simpleSpawn(FishOfThieves.CONFIG.spawnRate.snowWreckerProbability, SpawnSelectors.probability(FishOfThieves.CONFIG.spawnRate.snowWreckerProbability).and(SpawnSelectors.biomeTag(FOTTags.SPAWNS_SNOW_WRECKERS)))),
        MOON(SpawnSelectors.simpleSpawn(true, SpawnSelectors.nightAndSeeSky().and(context -> context.level().m_46940_() > 0.0f)));

        public static final Variant[] BY_ID;
        private final Predicate<SpawnConditionContext> condition;

        private Variant(Predicate<SpawnConditionContext> condition) {
            this.condition = condition;
        }

        @Override
        public String getName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        @Override
        public int getId() {
            return this.ordinal();
        }

        @Override
        public Predicate<SpawnConditionContext> getCondition() {
            return this.condition;
        }

        static {
            BY_ID = (Variant[])Stream.of(Variant.values()).sorted(Comparator.comparingInt(Variant::getId)).toArray(Variant[]::new);
        }
    }
}

