/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.forge.core;

import com.stevekung.fishofthieves.core.FishOfThieves;
import com.stevekung.fishofthieves.forge.compatibility.Aquaculture2;
import com.stevekung.fishofthieves.forge.proxy.ClientProxyForge;
import com.stevekung.fishofthieves.forge.proxy.CommonProxyForge;
import com.stevekung.fishofthieves.registry.FOTBlocks;
import com.stevekung.fishofthieves.registry.FOTEntities;
import com.stevekung.fishofthieves.registry.FOTItems;
import com.stevekung.fishofthieves.registry.FOTLootItemConditions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

@Mod(value="fishofthieves")
public class FishOfThievesForge {
    public static final DeferredRegister<Block> BLOCK = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"fishofthieves");
    public static final DeferredRegister<Item> ITEM = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"fishofthieves");
    public static final DeferredRegister<EntityType<?>> ENTITY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)"fishofthieves");
    public static final DeferredRegister<SoundEvent> SOUND_EVENTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"fishofthieves");
    public static CommonProxyForge PROXY;

    public FishOfThievesForge() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.register((Object)this);
        modEventBus.addListener(this::commonSetup);
        BLOCK.register(modEventBus);
        ITEM.register(modEventBus);
        ENTITY.register(modEventBus);
        SOUND_EVENTS.register(modEventBus);
        FishOfThieves.init();
        PROXY = (CommonProxyForge)DistExecutor.safeRunForDist(() -> ClientProxyForge::new, () -> CommonProxyForge::new);
        PROXY.init();
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        FishOfThieves.initCommon();
        if (ModList.get().isLoaded("aquaculture")) {
            Aquaculture2.init();
        }
    }

    @SubscribeEvent
    public void registerLootItemCondition(RegistryEvent.Register<Biome> event) {
        FOTLootItemConditions.init();
    }

    @SubscribeEvent
    public void registerBlock(RegistryEvent.Register<Block> event) {
        FOTBlocks.init();
    }

    @SubscribeEvent
    public void registerItem(RegistryEvent.Register<Item> event) {
        FOTItems.init();
    }

    @SubscribeEvent
    public void registerEntityType(RegistryEvent.Register<EntityType<?>> event) {
        FOTEntities.init();
    }
}

