/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.forge.proxy;

import com.google.common.collect.Lists;
import com.stevekung.fishofthieves.core.FishOfThieves;
import com.stevekung.fishofthieves.entity.animal.Battlegill;
import com.stevekung.fishofthieves.entity.animal.Devilfish;
import com.stevekung.fishofthieves.entity.animal.Wrecker;
import com.stevekung.fishofthieves.loot.FOTLootManager;
import com.stevekung.fishofthieves.registry.FOTEntities;
import com.stevekung.fishofthieves.registry.FOTItems;
import java.util.List;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.event.world.StructureSpawnListGatherEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.ArrayUtils;

public class CommonProxyForge {
    public void init() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::registerAttributes);
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        ComposterBlock.f_51914_.put((Object)FOTItems.EARTHWORMS, 0.4f);
        ComposterBlock.f_51914_.put((Object)FOTItems.GRUBS, 0.4f);
        ComposterBlock.f_51914_.put((Object)FOTItems.LEECHES, 0.4f);
    }

    public void clientSetup(FMLClientSetupEvent event) {
    }

    @SubscribeEvent
    public void registerLootTables(LootTableLoadEvent event) {
        ResourceLocation id = event.getName();
        LootTable table = event.getTable();
        if (id.equals((Object)BuiltInLootTables.f_78730_)) {
            CommonProxyForge.injectLoot(table, FOTLootManager.getFishermanGiftLoot((LootPool.Builder)LootPool.m_79043_()).f_79067_);
        } else if (id.equals((Object)BuiltInLootTables.f_78723_)) {
            CommonProxyForge.injectLoot(table, FOTLootManager.getFishingLoot((LootPool.Builder)LootPool.m_79043_()).f_79067_);
        } else if (id.equals((Object)EntityType.f_20514_.m_20677_())) {
            CommonProxyForge.injectLoot(table, FOTLootManager.getPolarBearLoot((LootPool.Builder)LootPool.m_79043_()).f_79067_);
        } else if (id.equals((Object)BuiltInLootTables.f_78751_)) {
            CommonProxyForge.injectLoot(table, FOTLootManager.getVillageFisherLoot((LootPool.Builder)LootPool.m_79043_()).f_79067_);
        } else if (id.equals((Object)BuiltInLootTables.f_78692_)) {
            table.addPool(FOTLootManager.getBuriedTreasureLoot(LootPool.m_79043_()).m_79082_());
        }
    }

    @SubscribeEvent
    public void registerVillagerTrades(VillagerTradesEvent event) {
        if (event.getType() == VillagerProfession.f_35591_) {
            event.getTrades().put(1, (Object)((List)Util.m_137469_((Object)Lists.newArrayList(), FishOfThieves::getTierOneTrades)));
            event.getTrades().put(2, (Object)((List)Util.m_137469_((Object)Lists.newArrayList(), FishOfThieves::getTierTwoTrades)));
        }
    }

    @SubscribeEvent
    public void registerMobSpawn(BiomeLoadingEvent event) {
        Biome.BiomeCategory category = event.getCategory();
        ResourceLocation name = event.getName();
        if (category == Biome.BiomeCategory.OCEAN) {
            event.getSpawns().m_48376_(FOTEntities.SPLASHTAIL.m_20674_(), new MobSpawnSettings.SpawnerData(FOTEntities.SPLASHTAIL, 15, 4, 8));
        }
        if (category == Biome.BiomeCategory.RIVER || category == Biome.BiomeCategory.FOREST) {
            event.getSpawns().m_48376_(FOTEntities.PONDIE.m_20674_(), new MobSpawnSettings.SpawnerData(FOTEntities.PONDIE, 15, 2, 4));
        }
        if (category == Biome.BiomeCategory.OCEAN || category == Biome.BiomeCategory.BEACH || category == Biome.BiomeCategory.JUNGLE || category == Biome.BiomeCategory.SWAMP || category == Biome.BiomeCategory.UNDERGROUND) {
            event.getSpawns().m_48376_(FOTEntities.ISLEHOPPER.m_20674_(), new MobSpawnSettings.SpawnerData(FOTEntities.ISLEHOPPER, 8, 2, 4));
        }
        if (Objects.equals(name, Biomes.f_48167_.m_135782_()) || Objects.equals(name, Biomes.f_48170_.m_135782_())) {
            event.getSpawns().m_48376_(FOTEntities.ANCIENTSCALE.m_20674_(), new MobSpawnSettings.SpawnerData(FOTEntities.ANCIENTSCALE, 8, 4, 8));
        }
        if (Objects.equals(name, Biomes.f_48166_.m_135782_()) || Objects.equals(name, Biomes.f_48167_.m_135782_()) || Objects.equals(name, Biomes.f_48170_.m_135782_()) || category == Biome.BiomeCategory.UNDERGROUND) {
            event.getSpawns().m_48376_(FOTEntities.PLENTIFIN.m_20674_(), new MobSpawnSettings.SpawnerData(FOTEntities.PLENTIFIN, 12, 4, 8));
        }
        if (Objects.equals(name, Biomes.f_151785_.m_135782_()) || Objects.equals(name, Biomes.f_48166_.m_135782_()) || category == Biome.BiomeCategory.OCEAN || category == Biome.BiomeCategory.BEACH || category == Biome.BiomeCategory.JUNGLE || category == Biome.BiomeCategory.SWAMP) {
            event.getSpawns().m_48376_(FOTEntities.WILDSPLASH.m_20674_(), new MobSpawnSettings.SpawnerData(FOTEntities.WILDSPLASH, 10, 2, 4));
        }
        if (!Objects.equals(name, Biomes.f_151785_.m_135782_())) {
            event.getSpawns().m_48376_(FOTEntities.DEVILFISH.m_20674_(), new MobSpawnSettings.SpawnerData(FOTEntities.DEVILFISH, 4, 1, 2));
        }
        event.getSpawns().m_48376_(FOTEntities.BATTLEGILL.m_20674_(), new MobSpawnSettings.SpawnerData(FOTEntities.BATTLEGILL, 5, 2, 4));
        if (category == Biome.BiomeCategory.OCEAN) {
            event.getSpawns().m_48376_(FOTEntities.WRECKER.m_20674_(), new MobSpawnSettings.SpawnerData(FOTEntities.WRECKER, 50, 4, 8));
        }
        if (category == Biome.BiomeCategory.OCEAN || Objects.equals(name, Biomes.f_186769_.m_135782_())) {
            event.getSpawns().m_48376_(FOTEntities.STORMFISH.m_20674_(), new MobSpawnSettings.SpawnerData(FOTEntities.STORMFISH, 12, 4, 8));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void addFishSpawnToStructure(StructureSpawnListGatherEvent event) {
        if (event.getStructure() == StructureFeature.f_67024_) {
            event.addEntitySpawns(MobCategory.WATER_AMBIENT, FOTEntities.ANCIENTSCALES.m_146338_());
        } else if (event.getStructure() == StructureFeature.f_67014_ || event.getStructure() == StructureFeature.f_67022_) {
            event.addEntitySpawns(MobCategory.WATER_AMBIENT, FOTEntities.ANCIENTSCALES_AND_PLENTIFINS.m_146338_());
        } else if (event.getStructure() == StructureFeature.f_67023_ || event.getStructure() == StructureFeature.f_67013_) {
            event.addEntitySpawns(MobCategory.WATER_AMBIENT, FOTEntities.BATTLEGILLS.m_146338_());
        } else if (event.getStructure() == StructureFeature.f_67020_ || event.getStructure() == StructureFeature.f_67019_) {
            event.addEntitySpawns(MobCategory.WATER_AMBIENT, FOTEntities.WRECKERS.m_146338_());
        }
    }

    public void registerAttributes(EntityAttributeCreationEvent event) {
        event.put(FOTEntities.SPLASHTAIL, AbstractFish.m_27495_().m_22265_());
        event.put(FOTEntities.PONDIE, AbstractFish.m_27495_().m_22265_());
        event.put(FOTEntities.ISLEHOPPER, AbstractFish.m_27495_().m_22265_());
        event.put(FOTEntities.ANCIENTSCALE, AbstractFish.m_27495_().m_22265_());
        event.put(FOTEntities.PLENTIFIN, AbstractFish.m_27495_().m_22265_());
        event.put(FOTEntities.WILDSPLASH, AbstractFish.m_27495_().m_22265_());
        event.put(FOTEntities.DEVILFISH, Devilfish.createAttributes().m_22265_());
        event.put(FOTEntities.BATTLEGILL, Battlegill.createAttributes().m_22265_());
        event.put(FOTEntities.WRECKER, Wrecker.createAttributes().m_22265_());
        event.put(FOTEntities.STORMFISH, AbstractFish.m_27495_().m_22265_());
    }

    private static void injectLoot(LootTable table, List<LootPoolEntryContainer> entries) {
        LootPool pool = table.getPool("main");
        pool.f_79023_ = (LootPoolEntryContainer[])ArrayUtils.addAll((Object[])pool.f_79023_, (Object[])((LootPoolEntryContainer[])entries.toArray(LootPoolEntryContainer[]::new)));
    }
}

