/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.predicates;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.stevekung.fishofthieves.predicates.FOTLocationPredicate;
import com.stevekung.fishofthieves.registry.FOTLootItemConditions;
import net.minecraft.core.BlockPos;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.phys.Vec3;

public class FOTLocationCheck
implements LootItemCondition {
    protected final FOTLocationPredicate predicate;
    protected final BlockPos offset;

    protected FOTLocationCheck(FOTLocationPredicate locationPredicate, BlockPos blockPos) {
        this.predicate = locationPredicate;
        this.offset = blockPos;
    }

    public LootItemConditionType m_7940_() {
        return FOTLootItemConditions.FOT_LOCATION_CHECK;
    }

    public boolean test(LootContext lootContext) {
        Vec3 vec3 = (Vec3)lootContext.m_78953_(LootContextParams.f_81460_);
        return vec3 != null && this.predicate.matches(lootContext.m_78952_(), vec3.m_7096_() + (double)this.offset.m_123341_(), vec3.m_7098_() + (double)this.offset.m_123342_(), vec3.m_7094_() + (double)this.offset.m_123343_());
    }

    public static LootItemCondition.Builder checkLocation(FOTLocationPredicate.Builder locationPredicateBuilder) {
        return () -> new FOTLocationCheck(locationPredicateBuilder.build(), BlockPos.f_121853_);
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<FOTLocationCheck> {
        public void serialize(JsonObject jsonObject, FOTLocationCheck locationCheck, JsonSerializationContext jsonSerializationContext) {
            jsonObject.add("predicate", locationCheck.predicate.serializeToJson());
            if (locationCheck.offset.m_123341_() != 0) {
                jsonObject.addProperty("offsetX", (Number)locationCheck.offset.m_123341_());
            }
            if (locationCheck.offset.m_123342_() != 0) {
                jsonObject.addProperty("offsetY", (Number)locationCheck.offset.m_123342_());
            }
            if (locationCheck.offset.m_123343_() != 0) {
                jsonObject.addProperty("offsetZ", (Number)locationCheck.offset.m_123343_());
            }
        }

        public FOTLocationCheck deserialize(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext) {
            FOTLocationPredicate locationPredicate = FOTLocationPredicate.fromJson(jsonObject.get("predicate"));
            int i = GsonHelper.m_13824_((JsonObject)jsonObject, (String)"offsetX", (int)0);
            int j = GsonHelper.m_13824_((JsonObject)jsonObject, (String)"offsetY", (int)0);
            int k = GsonHelper.m_13824_((JsonObject)jsonObject, (String)"offsetZ", (int)0);
            return new FOTLocationCheck(locationPredicate, new BlockPos(i, j, k));
        }
    }
}

