/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.spawn;

import com.stevekung.fishofthieves.core.FishOfThieves;
import com.stevekung.fishofthieves.spawn.SpawnConditionContext;
import com.stevekung.fishofthieves.utils.Continentalness;
import com.stevekung.fishofthieves.utils.TerrainUtils;
import java.util.Collections;
import java.util.EnumSet;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;

public final class SpawnSelectors {
    public static Predicate<SpawnConditionContext> always() {
        return context -> true;
    }

    public static Predicate<SpawnConditionContext> dayAndSeeSky() {
        return context -> context.isDay() && context.seeSkyInWater();
    }

    public static Predicate<SpawnConditionContext> nightAndSeeSky() {
        return context -> context.isNight() && context.seeSkyInWater();
    }

    public static Predicate<SpawnConditionContext> rainingAndSeeSky() {
        return context -> context.isRaining() && context.seeSkyInWater();
    }

    public static Predicate<SpawnConditionContext> thunderingAndSeeSky() {
        return context -> context.isRaining() && context.isThundering() && context.seeSkyInWater();
    }

    public static Predicate<SpawnConditionContext> probability(float probability) {
        return context -> context.random().nextFloat() < probability;
    }

    public static Predicate<SpawnConditionContext> simpleSpawn(Predicate<SpawnConditionContext> complex) {
        return SpawnSelectors.simpleSpawn(false, complex);
    }

    public static Predicate<SpawnConditionContext> simpleSpawn(boolean nightTime, Predicate<SpawnConditionContext> complex) {
        return FishOfThieves.CONFIG.general.simpleSpawningCondition ? (nightTime ? SpawnSelectors.nightAndSeeSky() : SpawnSelectors.always()) : complex;
    }

    public static Predicate<SpawnConditionContext> simpleSpawn(float probability, Predicate<SpawnConditionContext> complex) {
        return FishOfThieves.CONFIG.general.simpleSpawningCondition ? SpawnSelectors.probability(probability) : complex;
    }

    @SafeVarargs
    public static Predicate<SpawnConditionContext> features(ResourceKey<ConfiguredStructureFeature<?, ?>> ... structureFeatures) {
        return context -> {
            for (ResourceKey structureFeature : structureFeatures) {
                if (!TerrainUtils.isInFeature(context.level(), context.blockPos(), structureFeature)) continue;
                return true;
            }
            return false;
        };
    }

    public static Predicate<SpawnConditionContext> biomeTag(TagKey<Biome> tagKey) {
        return context -> context.level().m_204166_(context.blockPos()).m_203656_(tagKey);
    }

    public static Predicate<SpawnConditionContext> continentalness(Continentalness ... continentalnesses) {
        EnumSet<Continentalness> continentalnessSet = EnumSet.noneOf(Continentalness.class);
        Collections.addAll(continentalnessSet, continentalnesses);
        return context -> continentalnessSet.stream().anyMatch(continentalness -> context.continentalness() == continentalness);
    }

    public static SpawnConditionContext get(LivingEntity livingEntity) {
        ServerLevel level = (ServerLevel)livingEntity.f_19853_;
        BlockPos blockPos = livingEntity.m_142538_();
        return new SpawnConditionContext(level, blockPos, livingEntity.m_21187_(), level.m_46461_(), level.m_46462_(), level.m_46471_(), level.m_46470_(), level.m_46861_(blockPos), (Holder<Biome>)level.m_204166_(blockPos), TerrainUtils.getContinentalness(level, blockPos));
    }
}

