/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.stevekung.fishofthieves.api.block.FishPlaqueRegistry;
import com.stevekung.fishofthieves.api.block.FishPlaqueTagConverter;
import com.stevekung.fishofthieves.blockentity.FishPlaqueBlockEntity;
import com.stevekung.fishofthieves.registry.FOTSoundEvents;
import com.stevekung.fishofthieves.registry.FOTTags;
import com.stevekung.fishofthieves.utils.FOTPlatform;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class FishPlaqueBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    private final Map<Direction, VoxelShape> aabb;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final IntegerProperty ROTATION = IntegerProperty.m_61631_((String)"rotation", (int)1, (int)8);

    public FishPlaqueBlock(BlockBehaviour.Properties properties, Type type) {
        super(properties);
        this.aabb = type.aabb;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(1)));
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new FishPlaqueBlockEntity(pos, state);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.aabb.get(state.m_61143_((Property)FACING));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        FishPlaqueBlockEntity fishPlaque;
        BlockEntity blockEntity;
        Item item;
        ItemStack itemStack;
        block13: {
            block12: {
                itemStack = player.m_21120_(hand);
                item = itemStack.m_41720_();
                blockEntity = level.m_7702_(pos);
                if (!(blockEntity instanceof FishPlaqueBlockEntity)) break block12;
                fishPlaque = (FishPlaqueBlockEntity)blockEntity;
                if (!itemStack.m_204117_(FOTTags.Items.FISH_PLAQUE_BUCKET_BLACKLIST)) break block13;
            }
            return InteractionResult.PASS;
        }
        if (fishPlaque.hasPlaqueData()) {
            Entity entity = FishPlaqueBlockEntity.createEntity(fishPlaque, level);
            Item interactItem = FishPlaqueRegistry.getInteractionItem().getOrDefault(fishPlaque.getEntityKeyFromPlaqueData(), Items.f_42447_);
            if (itemStack.m_150930_(interactItem)) {
                if (entity instanceof Bucketable) {
                    Bucketable bucketable = (Bucketable)entity;
                    ItemStack itemStack2 = bucketable.m_28282_();
                    bucketable.m_6872_(itemStack2);
                    level.m_5594_(player, pos, bucketable.m_142623_(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                    ItemStack itemStack3 = ItemUtils.m_41817_((ItemStack)itemStack, (Player)player, (ItemStack)itemStack2, (boolean)false);
                    player.m_21008_(hand, itemStack3);
                    fishPlaque.clearDisplayEntity();
                    blockEntity.m_6596_();
                    level.m_7260_(pos, state, state, 3);
                    level.m_142346_((Entity)player, GameEvent.f_157792_, pos);
                }
            } else {
                level.m_5594_(player, pos, FOTSoundEvents.FISH_PLAQUE_ROTATE, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.m_7260_(pos, state, state, 3);
                level.m_142346_((Entity)player, GameEvent.f_157792_, pos);
                level.m_7731_(pos, FishPlaqueBlock.cycleRotation(state, player.m_36341_()), 3);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        if (item instanceof MobBucketItem) {
            MobBucketItem bucket = (MobBucketItem)item;
            CompoundTag tag = itemStack.m_41777_().m_41784_();
            EntityType<?> entityType = FOTPlatform.getMobInBucketItem(bucket);
            String entityKey = Registry.f_122826_.m_7981_(entityType).toString();
            Item interactItem = FishPlaqueRegistry.getInteractionItem().getOrDefault(entityKey, Items.f_42447_);
            FishPlaqueTagConverter converter = FishPlaqueRegistry.getTagConverter(entityType);
            tag.m_128359_("id", entityKey);
            if (converter != FishPlaqueTagConverter.NOOP) {
                converter.convert(tag);
            }
            level.m_5594_(player, pos, FOTPlatform.getEmptySoundInBucketItem(bucket), SoundSource.NEUTRAL, 1.0f, 1.0f);
            fishPlaque.setPlaqueData(tag);
            blockEntity.m_6596_();
            level.m_7260_(pos, state, state, 3);
            level.m_142346_((Entity)player, GameEvent.f_157792_, pos);
            if (!player.m_150110_().f_35937_) {
                player.m_21008_(hand, new ItemStack((ItemLike)interactItem));
            }
            if (!level.f_46443_) {
                player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction[] directions;
        BlockState blockState = this.m_49966_();
        FluidState fluidState = context.m_43725_().m_6425_(context.m_8083_());
        Level levelReader = context.m_43725_();
        BlockPos blockPos = context.m_8083_();
        for (Direction direction : directions = context.m_6232_()) {
            Direction direction2;
            if (!direction.m_122434_().m_122479_() || !(blockState = (BlockState)blockState.m_61124_((Property)FACING, (Comparable)(direction2 = direction.m_122424_()))).m_60710_((LevelReader)levelReader, blockPos)) continue;
            return (BlockState)blockState.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
        }
        return null;
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        BlockPos blockPos = pos.m_121945_(direction.m_122424_());
        BlockState blockState = level.m_8055_(blockPos);
        return blockState.m_60783_((BlockGetter)level, blockPos, direction);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof FishPlaqueBlockEntity) {
                level.m_46717_(pos, state.m_60734_());
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    public void m_213646_(BlockState state, ServerLevel level, BlockPos pos, ItemStack stack, boolean dropExperience) {
        super.m_213646_(state, level, pos, stack, dropExperience);
        this.spawnFish(state, (Level)level, pos, level.m_7702_(pos));
    }

    public void m_6240_(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, ItemStack tool) {
        super.m_6240_(level, player, pos, state, blockEntity, tool);
        if (!level.f_46443_) {
            this.spawnFish(state, level, pos, blockEntity);
        }
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return direction.m_122424_() == state.m_61143_((Property)FACING) && !state.m_60710_((LevelReader)level, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_5568_() {
        return true;
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        FishPlaqueBlockEntity fishPlaque;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FishPlaqueBlockEntity && (fishPlaque = (FishPlaqueBlockEntity)blockEntity).hasPlaqueData()) {
            return (Integer)state.m_61143_((Property)ROTATION);
        }
        return 0;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, WATERLOGGED, ROTATION});
    }

    private void spawnFish(BlockState state, Level level, BlockPos pos, BlockEntity blockEntity) {
        FishPlaqueBlockEntity fishPlaque;
        if (blockEntity instanceof FishPlaqueBlockEntity && (fishPlaque = (FishPlaqueBlockEntity)blockEntity).hasPlaqueData()) {
            Entity entity = FishPlaqueBlockEntity.createEntity(fishPlaque, level);
            Direction direction = (Direction)state.m_61143_((Property)FACING);
            double random = level.f_46441_.m_188500_() * 0.1 + 0.2;
            if (!((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
                entity.m_20301_(100);
            }
            entity.m_7678_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, direction.m_122435_(), 0.0f);
            entity.m_20334_(level.f_46441_.m_216328_((double)direction.m_122429_() * random, 0.0172275), 0.4, level.f_46441_.m_216328_((double)direction.m_122431_() * random, 0.0172275));
            level.m_7967_(entity);
        }
    }

    private static BlockState cycleRotation(BlockState state, boolean backwards) {
        return (BlockState)state.m_61124_((Property)ROTATION, (Comparable)FishPlaqueBlock.getRelative(ROTATION.m_6908_(), (Integer)state.m_61143_((Property)ROTATION), backwards));
    }

    private static <T> T getRelative(Iterable<T> allowedValues, @Nullable T currentValue, boolean backwards) {
        return (T)(backwards ? Util.m_137554_(allowedValues, currentValue) : Util.m_137466_(allowedValues, currentValue));
    }

    public static enum Type {
        WOODEN(Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.m_49796_((double)0.0, (double)4.0, (double)14.0, (double)16.0, (double)12.0, (double)16.0), (Object)Direction.SOUTH, (Object)Block.m_49796_((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)12.0, (double)2.0), (Object)Direction.EAST, (Object)Block.m_49796_((double)0.0, (double)4.0, (double)0.0, (double)2.0, (double)12.0, (double)16.0), (Object)Direction.WEST, (Object)Block.m_49796_((double)14.0, (double)4.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0)))),
        IRON(Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.m_49796_((double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0, (double)16.0), (Object)Direction.SOUTH, (Object)Block.m_49796_((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)13.0, (double)3.0), (Object)Direction.EAST, (Object)Block.m_49796_((double)0.0, (double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0), (Object)Direction.WEST, (Object)Block.m_49796_((double)13.0, (double)3.0, (double)0.0, (double)16.0, (double)13.0, (double)16.0)))),
        GOLDEN(Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.m_49796_((double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0, (double)16.0), (Object)Direction.SOUTH, (Object)Block.m_49796_((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)13.0, (double)3.0), (Object)Direction.EAST, (Object)Block.m_49796_((double)0.0, (double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0), (Object)Direction.WEST, (Object)Block.m_49796_((double)13.0, (double)3.0, (double)0.0, (double)16.0, (double)13.0, (double)16.0)))),
        GILDED(Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Shapes.m_83113_((VoxelShape)Block.m_49796_((double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0, (double)16.0), (VoxelShape)Block.m_49796_((double)1.0, (double)13.0, (double)14.0, (double)15.0, (double)15.0, (double)16.0), (BooleanOp)BooleanOp.f_82695_), (Object)Direction.SOUTH, (Object)Shapes.m_83113_((VoxelShape)Block.m_49796_((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)13.0, (double)3.0), (VoxelShape)Block.m_49796_((double)1.0, (double)13.0, (double)0.0, (double)15.0, (double)15.0, (double)2.0), (BooleanOp)BooleanOp.f_82695_), (Object)Direction.EAST, (Object)Shapes.m_83113_((VoxelShape)Block.m_49796_((double)0.0, (double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0), (VoxelShape)Block.m_49796_((double)0.0, (double)13.0, (double)1.0, (double)2.0, (double)15.0, (double)15.0), (BooleanOp)BooleanOp.f_82695_), (Object)Direction.WEST, (Object)Shapes.m_83113_((VoxelShape)Block.m_49796_((double)13.0, (double)3.0, (double)0.0, (double)16.0, (double)13.0, (double)16.0), (VoxelShape)Block.m_49796_((double)14.0, (double)13.0, (double)1.0, (double)16.0, (double)15.0, (double)15.0), (BooleanOp)BooleanOp.f_82695_))));

        private final Map<Direction, VoxelShape> aabb;

        private Type(Map<Direction, VoxelShape> aabb) {
            this.aabb = aabb;
        }
    }
}

