/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.entity.animal;

import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.entity.AbstractThievesFish;
import com.stevekung.fishofthieves.entity.variant.WreckerVariant;
import com.stevekung.fishofthieves.registry.FOTDataSerializers;
import com.stevekung.fishofthieves.registry.FOTItems;
import com.stevekung.fishofthieves.registry.FOTRegistry;
import com.stevekung.fishofthieves.registry.FOTSoundEvents;
import com.stevekung.fishofthieves.registry.FOTTags;
import com.stevekung.fishofthieves.registry.variant.WreckerVariants;
import com.stevekung.fishofthieves.utils.TerrainUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Wrecker
extends AbstractThievesFish<WreckerVariant> {
    private static final Predicate<LivingEntity> SELECTORS = livingEntity -> livingEntity.m_6336_() != MobType.f_21644_ && livingEntity.m_20069_() && livingEntity.m_5789_();
    private static final EntityDataAccessor<WreckerVariant> VARIANT = SynchedEntityData.m_135353_(Wrecker.class, FOTDataSerializers.WRECKER_VARIANT);
    public static final Consumer<Int2ObjectOpenHashMap<String>> DATA_FIX_MAP = map -> {
        map.defaultReturnValue((Object)"fishofthieves:rose");
        map.put(0, (Object)"fishofthieves:rose");
        map.put(1, (Object)"fishofthieves:sun");
        map.put(2, (Object)"fishofthieves:blackcloud");
        map.put(3, (Object)"fishofthieves:snow");
        map.put(4, (Object)"fishofthieves:moon");
    };

    public Wrecker(EntityType<? extends Wrecker> entityType, Level level) {
        super(entityType, level);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(2, (Goal)new SwimToNearbyWreckageGoal(this, 1.25));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.25, EARTHWORMS_FOOD, false));
        if (FishOfThieves.CONFIG.general.neutralFishBehavior) {
            this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 2.0, true));
            this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Monster.class, 20, true, false, SELECTORS));
            this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 50, true, false, SELECTORS));
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)WreckerVariants.ROSE);
    }

    @Override
    public Registry<WreckerVariant> getRegistry() {
        return FOTRegistry.WRECKER_VARIANT;
    }

    @Override
    public void setVariant(WreckerVariant variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    @Override
    public WreckerVariant getVariant() {
        return (WreckerVariant)this.f_19804_.m_135370_(VARIANT);
    }

    @Override
    public Holder<WreckerVariant> getSpawnVariant(boolean fromBucket) {
        return this.getSpawnVariant((LivingEntity)this, FOTTags.FishVariant.DEFAULT_WRECKER_SPAWNS, WreckerVariants.ROSE, fromBucket);
    }

    @Override
    public Consumer<Int2ObjectOpenHashMap<String>> getDataFix() {
        return DATA_FIX_MAP;
    }

    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)FOTItems.WRECKER_BUCKET);
    }

    protected SoundEvent m_5592_() {
        return FOTSoundEvents.WRECKER_DEATH;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return FOTSoundEvents.WRECKER_HURT;
    }

    protected SoundEvent m_5699_() {
        return FOTSoundEvents.WRECKER_FLOP;
    }

    public EntityDimensions m_6972_(Pose pose) {
        return this.isTrophy() ? super.m_6972_(pose) : EntityDimensions.m_20398_((float)0.275f, (float)0.25f);
    }

    protected float m_6431_(Pose pose, EntityDimensions size) {
        return this.isTrophy() ? 0.34f : 0.175f;
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        spawnData = super.m_6518_(level, difficulty, reason, spawnData, dataTag);
        if (this.isTrophy()) {
            this.m_21051_(Attributes.f_22281_).m_22100_(2.5);
        }
        return spawnData;
    }

    @Override
    public void setTrophy(boolean trophy) {
        if (trophy) {
            this.m_21051_(Attributes.f_22281_).m_22100_(2.5);
        }
        super.setTrophy(trophy);
    }

    @Override
    public boolean isFood(ItemStack itemStack) {
        return EARTHWORMS_FOOD.test(itemStack);
    }

    public static boolean checkSpawnRules(EntityType<? extends WaterAnimal> entityType, ServerLevelAccessor level, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource random) {
        boolean isWater = level.m_6425_(blockPos).m_205070_(FluidTags.f_13131_) && level.m_8055_(blockPos).m_60713_(Blocks.f_49990_);
        return isWater && TerrainUtils.isInFeature(level.m_6018_(), blockPos, FOTTags.Structures.WRECKERS_SPAWN_IN);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 3.0).m_22268_(Attributes.f_22277_, 10.0).m_22268_(Attributes.f_22281_, 1.5).m_22268_(Attributes.f_22282_, 0.01);
    }

    static class SwimToNearbyWreckageGoal
    extends RandomStrollGoal {
        SwimToNearbyWreckageGoal(Wrecker wrecker, double speedModifier) {
            super((PathfinderMob)wrecker, speedModifier);
        }

        @Nullable
        protected Vec3 m_7037_() {
            BlockPos wreckagePos = ((ServerLevel)this.f_25725_.f_19853_).m_215011_(FOTTags.Structures.WRECKERS_LOCATED, this.f_25725_.m_20183_(), 32, false);
            if (this.f_25725_.f_19853_.f_46441_.m_188501_() < 0.3f) {
                return LandRandomPos.m_148488_((PathfinderMob)this.f_25725_, (int)10, (int)7);
            }
            if (wreckagePos != null) {
                return Vec3.m_82512_((Vec3i)wreckagePos);
            }
            return super.m_7037_();
        }
    }
}

