/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.forge.datagen;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.registry.FOTEntities;
import com.stevekung.fishofthieves.registry.FOTItems;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.tags.BlockTagsProvider;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(modid="fishofthieves", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGeneratorFOT {
    private static final TagKey<Item> RAW_FISHES = TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)new ResourceLocation("forge", "raw_fishes"));
    private static final TagKey<Item> COOKED_FISHES = TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)new ResourceLocation("forge", "cooked_fishes"));

    @SubscribeEvent
    public static void onGatherData(GatherDataEvent event) {
        DataGenerator dataGenerator = event.getGenerator();
        ExistingFileHelper helper = event.getExistingFileHelper();
        dataGenerator.m_236039_(event.includeServer(), (DataProvider)new ForgeItemTags(dataGenerator, "fishofthieves", helper));
        dataGenerator.m_236039_(event.includeServer(), (DataProvider)new FishingReal(dataGenerator));
    }

    private static class ForgeItemTags
    extends ItemTagsProvider {
        public ForgeItemTags(DataGenerator dataGenerator, String modId, @Nullable ExistingFileHelper existingFileHelper) {
            super(dataGenerator, new BlockTagsProvider(dataGenerator, modId, existingFileHelper), modId, existingFileHelper);
        }

        protected void m_6577_() {
            Object[] rawFishes = new Item[]{FOTItems.SPLASHTAIL, FOTItems.PONDIE, FOTItems.ISLEHOPPER, FOTItems.ANCIENTSCALE, FOTItems.PLENTIFIN, FOTItems.WILDSPLASH, FOTItems.DEVILFISH, FOTItems.BATTLEGILL, FOTItems.WRECKER, FOTItems.STORMFISH};
            Object[] cookedFishes = new Item[]{FOTItems.COOKED_SPLASHTAIL, FOTItems.COOKED_PONDIE, FOTItems.COOKED_ISLEHOPPER, FOTItems.COOKED_ANCIENTSCALE, FOTItems.COOKED_PLENTIFIN, FOTItems.COOKED_WILDSPLASH, FOTItems.COOKED_DEVILFISH, FOTItems.COOKED_BATTLEGILL, FOTItems.COOKED_WRECKER, FOTItems.COOKED_STORMFISH};
            this.m_206424_(RAW_FISHES).m_126584_(rawFishes);
            this.m_206424_(COOKED_FISHES).m_126584_(cookedFishes);
        }
    }

    private static class FishingReal
    extends FishingRealProvider {
        public FishingReal(DataGenerator dataGenerator) {
            super(dataGenerator);
        }

        @Override
        public void addFishingReal() {
            this.add(FOTItems.SPLASHTAIL, FOTEntities.SPLASHTAIL);
            this.add(FOTItems.PONDIE, FOTEntities.PONDIE);
            this.add(FOTItems.ISLEHOPPER, FOTEntities.ISLEHOPPER);
            this.add(FOTItems.ANCIENTSCALE, FOTEntities.ANCIENTSCALE);
            this.add(FOTItems.PLENTIFIN, FOTEntities.PLENTIFIN);
            this.add(FOTItems.WILDSPLASH, FOTEntities.WILDSPLASH);
            this.add(FOTItems.DEVILFISH, FOTEntities.DEVILFISH);
            this.add(FOTItems.BATTLEGILL, FOTEntities.BATTLEGILL);
            this.add(FOTItems.WRECKER, FOTEntities.WRECKER);
            this.add(FOTItems.STORMFISH, FOTEntities.STORMFISH);
        }
    }

    private static abstract class FishingRealProvider
    implements DataProvider {
        private final Map<ResourceLocation, FishingRealBuilder> builders = Maps.newLinkedHashMap();
        private final DataGenerator dataGenerator;

        public FishingRealProvider(DataGenerator dataGenerator) {
            this.dataGenerator = dataGenerator;
        }

        public abstract void addFishingReal();

        public void add(Item item, EntityType<?> entityType) {
            this.add(item, entityType, null);
        }

        public void add(Item item, EntityType<?> entityType, @Nullable CompoundTag compoundTag) {
            FishingRealBuilder builder = new FishingRealBuilder(item, entityType, compoundTag);
            this.builders.put(ForgeRegistries.ENTITY_TYPES.getKey(entityType), builder);
        }

        public void m_213708_(CachedOutput cachedOutput) {
            this.builders.clear();
            this.addFishingReal();
            this.builders.forEach((resourceLocation, builder) -> {
                JsonObject jsonObject = builder.serializeToJson();
                Path path = this.getPath((ResourceLocation)resourceLocation);
                try {
                    DataProvider.m_236072_((CachedOutput)cachedOutput, (JsonElement)jsonObject, (Path)path);
                }
                catch (IOException e) {
                    FishOfThieves.LOGGER.error("Couldn't save FishingReal to {}", (Object)path, (Object)e);
                }
            });
        }

        public String m_6055_() {
            return "FishingReal";
        }

        private Path getPath(ResourceLocation id) {
            return this.dataGenerator.m_123916_().resolve("data/fishingreal/fishing/" + id.m_135815_() + ".json");
        }

        record FishingRealBuilder(Item item, EntityType<?> entityType, @Nullable CompoundTag compoundTag) {
            public JsonObject serializeToJson() {
                JsonObject jsonObject = new JsonObject();
                JsonObject jsonItem = new JsonObject();
                JsonObject jsonResult = new JsonObject();
                jsonItem.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)this.item).toString());
                jsonResult.addProperty("id", ForgeRegistries.ENTITY_TYPES.getKey(this.entityType).toString());
                if (this.compoundTag != null) {
                    jsonResult.addProperty("nbt", this.compoundTag.toString());
                }
                jsonObject.add("input", (JsonElement)jsonItem);
                jsonObject.add("result", (JsonElement)jsonResult);
                return jsonObject;
            }
        }
    }
}

