/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.forge.datagen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.forge.FishOfThievesForge;
import com.stevekung.fishofthieves.registry.FOTEntities;
import com.stevekung.fishofthieves.registry.FOTTags;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.JsonCodecProvider;
import net.minecraftforge.common.world.ModifiableStructureInfo;
import net.minecraftforge.common.world.StructureModifier;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class FOTStructureModifiers {
    private static final Codec<TagKey<Structure>> STRUCTURE_LIST_CODEC = TagKey.m_203886_((ResourceKey)Registry.f_235725_);

    public static void generateStructureModifiers(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        RegistryOps ops = RegistryOps.m_206821_((DynamicOps)JsonOps.INSTANCE, (RegistryAccess)RegistryAccess.m_206197_());
        generator.m_236039_(event.includeServer(), (DataProvider)JsonCodecProvider.forDatapackRegistry((DataGenerator)generator, (ExistingFileHelper)event.getExistingFileHelper(), (String)"fishofthieves", (RegistryOps)ops, (ResourceKey)ForgeRegistries.Keys.STRUCTURE_MODIFIERS, Map.of(FishOfThieves.res("ancientscales_spawn_in"), FOTStructureModifiers.addStructureSpawns((MobSpawnSettings.SpawnerData)FOTEntities.SpawnData.ANCIENTSCALE.m_146338_().get(0), FOTTags.Structures.ANCIENTSCALES_SPAWN_IN), FishOfThieves.res("plentifins_spawn_in"), FOTStructureModifiers.addStructureSpawns((MobSpawnSettings.SpawnerData)FOTEntities.SpawnData.PLENTIFIN.m_146338_().get(0), FOTTags.Structures.PLENTIFINS_SPAWN_IN), FishOfThieves.res("wreckers_spawn_in"), FOTStructureModifiers.addStructureSpawns((MobSpawnSettings.SpawnerData)FOTEntities.SpawnData.WRECKER.m_146338_().get(0), FOTTags.Structures.WRECKERS_SPAWN_IN), FishOfThieves.res("battlegills_spawn_in"), FOTStructureModifiers.addStructureSpawns((MobSpawnSettings.SpawnerData)FOTEntities.SpawnData.BATTLEGILL.m_146338_().get(0), FOTTags.Structures.BATTLEGILLS_SPAWN_IN))));
    }

    private static StructureModifier addStructureSpawns(MobSpawnSettings.SpawnerData spawnerData, TagKey<Structure> structureTagKey) {
        return new Modifier(structureTagKey, spawnerData);
    }

    public record Modifier(TagKey<Structure> structureTagKey, MobSpawnSettings.SpawnerData spawnerData) implements StructureModifier
    {
        private static final RegistryObject<Codec<? extends StructureModifier>> SERIALIZER = RegistryObject.create((ResourceLocation)FishOfThievesForge.ADD_THIEVES_FISH_SPAWNS_IN_STRUCTURE_RL, (ResourceKey)ForgeRegistries.Keys.STRUCTURE_MODIFIER_SERIALIZERS, (String)"fishofthieves");

        public void modify(Holder<Structure> structure, StructureModifier.Phase phase, ModifiableStructureInfo.StructureInfo.Builder builder) {
            if (phase == StructureModifier.Phase.ADD && structure.m_203656_(this.structureTagKey)) {
                builder.getStructureSettings().getOrAddSpawnOverrides(this.spawnerData.f_48404_.m_20674_()).addSpawn(this.spawnerData);
            }
        }

        public Codec<? extends StructureModifier> codec() {
            return (Codec)SERIALIZER.get();
        }

        public static Codec<Modifier> makeCodec() {
            return RecordCodecBuilder.create(builder -> builder.group((App)STRUCTURE_LIST_CODEC.fieldOf("structure").forGetter(Modifier::structureTagKey), (App)MobSpawnSettings.SpawnerData.f_48403_.fieldOf("spawnerData").forGetter(Modifier::spawnerData)).apply((Applicative)builder, Modifier::new));
        }
    }
}

