/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.forge.proxy;

import com.google.common.collect.Lists;
import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.entity.animal.Ancientscale;
import com.stevekung.fishofthieves.entity.animal.Battlegill;
import com.stevekung.fishofthieves.entity.animal.Devilfish;
import com.stevekung.fishofthieves.entity.animal.Islehopper;
import com.stevekung.fishofthieves.entity.animal.Plentifin;
import com.stevekung.fishofthieves.entity.animal.Stormfish;
import com.stevekung.fishofthieves.entity.animal.Wildsplash;
import com.stevekung.fishofthieves.entity.animal.Wrecker;
import com.stevekung.fishofthieves.loot.FOTLootManager;
import com.stevekung.fishofthieves.registry.FOTEntities;
import com.stevekung.fishofthieves.registry.FOTItems;
import com.stevekung.fishofthieves.registry.FOTTags;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.ArrayUtils;

public class CommonProxyForge {
    public void init() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::registerAttributes);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::registerSpawnPlacement);
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        ComposterBlock.f_51914_.put((Object)FOTItems.EARTHWORMS, 0.4f);
        ComposterBlock.f_51914_.put((Object)FOTItems.GRUBS, 0.4f);
        ComposterBlock.f_51914_.put((Object)FOTItems.LEECHES, 0.4f);
    }

    public void clientSetup(FMLClientSetupEvent event) {
    }

    @SubscribeEvent
    public void onFuelBurnTime(FurnaceFuelBurnTimeEvent event) {
        ItemStack itemStack = event.getItemStack();
        if (itemStack.m_204117_(FOTTags.Items.WOODEN_FISH_PLAQUE)) {
            event.setBurnTime(300);
        }
    }

    @SubscribeEvent
    public void registerLootTables(LootTableLoadEvent event) {
        ResourceLocation id = event.getName();
        LootTable table = event.getTable();
        if (id.equals((Object)BuiltInLootTables.f_78730_)) {
            CommonProxyForge.injectLoot(table, FOTLootManager.getFishermanGiftLoot((LootPool.Builder)LootPool.m_79043_()).f_79067_);
        } else if (id.equals((Object)BuiltInLootTables.f_78723_)) {
            CommonProxyForge.injectLoot(table, FOTLootManager.getFishingLoot((LootPool.Builder)LootPool.m_79043_()).f_79067_);
        } else if (id.equals((Object)EntityType.f_20514_.m_20677_())) {
            CommonProxyForge.injectLoot(table, FOTLootManager.getPolarBearLoot((LootPool.Builder)LootPool.m_79043_()).f_79067_);
        } else if (id.equals((Object)BuiltInLootTables.f_78751_)) {
            CommonProxyForge.injectLoot(table, FOTLootManager.getVillageFisherLoot((LootPool.Builder)LootPool.m_79043_()).f_79067_);
        } else if (id.equals((Object)BuiltInLootTables.f_78692_)) {
            table.addPool(FOTLootManager.getBuriedTreasureLoot(LootPool.m_79043_()).m_79082_());
        }
    }

    @SubscribeEvent
    public void registerVillagerTrades(VillagerTradesEvent event) {
        if (event.getType() == VillagerProfession.f_35591_) {
            Int2ObjectMap trades = event.getTrades();
            ((List)trades.get(1)).addAll(FishOfThieves.getFishermanTradesByLevel(1, Lists.newArrayList()));
            ((List)trades.get(2)).addAll(FishOfThieves.getFishermanTradesByLevel(2, Lists.newArrayList()));
            ((List)trades.get(3)).addAll(FishOfThieves.getFishermanTradesByLevel(3, Lists.newArrayList()));
            ((List)trades.get(4)).addAll(FishOfThieves.getFishermanTradesByLevel(4, Lists.newArrayList()));
            ((List)trades.get(5)).addAll(FishOfThieves.getFishermanTradesByLevel(5, Lists.newArrayList()));
        }
    }

    private void registerSpawnPlacement(SpawnPlacementRegisterEvent event) {
        event.register(FOTEntities.SPLASHTAIL, SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, WaterAnimal::m_218282_, SpawnPlacementRegisterEvent.Operation.OR);
        event.register(FOTEntities.PONDIE, SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, WaterAnimal::m_218282_, SpawnPlacementRegisterEvent.Operation.OR);
        event.register(FOTEntities.ISLEHOPPER, SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Islehopper::checkSpawnRules, SpawnPlacementRegisterEvent.Operation.OR);
        event.register(FOTEntities.ANCIENTSCALE, SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Ancientscale::checkSpawnRules, SpawnPlacementRegisterEvent.Operation.OR);
        event.register(FOTEntities.PLENTIFIN, SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Plentifin::checkSpawnRules, SpawnPlacementRegisterEvent.Operation.OR);
        event.register(FOTEntities.WILDSPLASH, SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Wildsplash::checkSpawnRules, SpawnPlacementRegisterEvent.Operation.OR);
        event.register(FOTEntities.DEVILFISH, SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Devilfish::checkSpawnRules, SpawnPlacementRegisterEvent.Operation.OR);
        event.register(FOTEntities.BATTLEGILL, SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Battlegill::checkSpawnRules, SpawnPlacementRegisterEvent.Operation.OR);
        event.register(FOTEntities.WRECKER, SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Wrecker::checkSpawnRules, SpawnPlacementRegisterEvent.Operation.OR);
        event.register(FOTEntities.STORMFISH, SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Stormfish::checkSpawnRules, SpawnPlacementRegisterEvent.Operation.OR);
    }

    private void registerAttributes(EntityAttributeCreationEvent event) {
        event.put(FOTEntities.SPLASHTAIL, AbstractFish.m_27495_().m_22265_());
        event.put(FOTEntities.PONDIE, AbstractFish.m_27495_().m_22265_());
        event.put(FOTEntities.ISLEHOPPER, AbstractFish.m_27495_().m_22265_());
        event.put(FOTEntities.ANCIENTSCALE, AbstractFish.m_27495_().m_22265_());
        event.put(FOTEntities.PLENTIFIN, AbstractFish.m_27495_().m_22265_());
        event.put(FOTEntities.WILDSPLASH, AbstractFish.m_27495_().m_22265_());
        event.put(FOTEntities.DEVILFISH, Devilfish.createAttributes().m_22265_());
        event.put(FOTEntities.BATTLEGILL, Battlegill.createAttributes().m_22265_());
        event.put(FOTEntities.WRECKER, Wrecker.createAttributes().m_22265_());
        event.put(FOTEntities.STORMFISH, AbstractFish.m_27495_().m_22265_());
    }

    private static void injectLoot(LootTable table, List<LootPoolEntryContainer> entries) {
        LootPool pool = table.getPool("main");
        pool.f_79023_ = (LootPoolEntryContainer[])ArrayUtils.addAll((Object[])pool.f_79023_, (Object[])((LootPoolEntryContainer[])entries.toArray(LootPoolEntryContainer[]::new)));
    }
}

