/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.item;

import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.entity.ThievesFish;
import com.stevekung.fishofthieves.registry.FOTTags;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;

public class FOTMobBucketItem
extends MobBucketItem {
    private final EntityType<?> entityType;
    private final Consumer<Int2ObjectOpenHashMap<String>> dataFixMap;

    public FOTMobBucketItem(EntityType<?> entityType, Fluid fluid, SoundEvent soundEvent, Consumer<Int2ObjectOpenHashMap<String>> dataFixMap, Item.Properties properties) {
        super(entityType, fluid, soundEvent, properties);
        this.entityType = entityType;
        this.dataFixMap = dataFixMap;
    }

    public void m_142312_(CompoundTag compoundTag) {
        super.m_142312_(compoundTag);
        ThievesFish.fixData(compoundTag, this.dataFixMap);
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        CompoundTag compoundTag = itemStack.m_41783_();
        if (this.entityType.m_204039_(FOTTags.EntityTypes.THIEVES_FISH_ENTITY_TYPE)) {
            if (itemStack.m_41782_()) {
                if (compoundTag.m_128425_("variant", 8)) {
                    MutableComponent type = this.createTooltip(compoundTag.m_128461_("variant"));
                    if (compoundTag.m_128471_("Trophy")) {
                        type.m_130946_(", ").m_7220_((Component)Component.m_237115_((String)"entity.fishofthieves.trophy"));
                    }
                    tooltipComponents.add((Component)type);
                }
            } else if (FishOfThieves.CONFIG.general.displayAllFishVariantInCreativeTab) {
                Int2ObjectOpenHashMap variantMap = (Int2ObjectOpenHashMap)Util.m_137469_((Object)new Int2ObjectOpenHashMap(), this.dataFixMap);
                tooltipComponents.add((Component)this.createTooltip((String)variantMap.get(0)));
            }
        }
    }

    public void m_6787_(CreativeModeTab tab, NonNullList<ItemStack> items) {
        super.m_6787_(tab, items);
        if (this.m_220152_(tab) && FishOfThieves.CONFIG.general.displayAllFishVariantInCreativeTab) {
            for (int i = 1; i < 5; ++i) {
                items.add((Object)FOTMobBucketItem.create((Item)this, this.dataFixMap, i));
            }
        }
    }

    private MutableComponent createTooltip(String location) {
        return Component.m_237115_((String)"entity.fishofthieves.%s.%s".formatted(Registry.f_122826_.m_7981_(this.entityType).m_135815_(), ResourceLocation.m_135820_((String)location).m_135815_())).m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY});
    }

    private static ItemStack create(Item item, Consumer<Int2ObjectOpenHashMap<String>> dataFixMap, int index) {
        ItemStack itemStack = new ItemStack((ItemLike)item);
        CompoundTag compoundTag = itemStack.m_41784_();
        Int2ObjectOpenHashMap variant = (Int2ObjectOpenHashMap)Util.m_137469_((Object)new Int2ObjectOpenHashMap(), dataFixMap);
        compoundTag.m_128405_("CustomModelData", index);
        compoundTag.m_128359_("variant", (String)variant.get(index));
        return itemStack;
    }
}

