/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.loot.function;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.registry.FOTLootPoolEntries;
import java.util.function.Consumer;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class FOTLootItem
extends LootPoolSingletonContainer {
    final Item item;

    FOTLootItem(Item item, int weight, int quality, LootItemCondition[] conditions, LootItemFunction[] functions) {
        super(weight, quality, conditions, functions);
        this.item = item;
    }

    public LootPoolEntryType m_6751_() {
        return FOTLootPoolEntries.FOT_ITEM;
    }

    public void m_6948_(Consumer<ItemStack> stackConsumer, LootContext lootContext) {
        ItemStack itemStack = new ItemStack((ItemLike)this.item);
        if (FishOfThieves.CONFIG.general.dropAndPickFishesWithVariant) {
            boolean isNight = !lootContext.m_78952_().m_46461_();
            RandomSource random = lootContext.m_230907_();
            double chance = random.m_188500_();
            int data = 0;
            if (chance < 0.7) {
                data = isNight && random.m_188503_(3) == 0 ? 4 : 0;
            } else if (chance < 0.85) {
                data = 1;
            } else if (chance < 0.95) {
                data = 2;
            } else if (chance < 1.0) {
                data = 3;
            }
            if (data > 0) {
                itemStack.m_41784_().m_128405_("CustomModelData", data);
            }
        }
        stackConsumer.accept(itemStack);
    }

    public static LootPoolSingletonContainer.Builder<?> lootTableItem(ItemLike item) {
        return FOTLootItem.m_79687_((weight, quality, conditions, functions) -> new FOTLootItem(item.m_5456_(), weight, quality, conditions, functions));
    }

    public static class Serializer
    extends LootPoolSingletonContainer.Serializer<FOTLootItem> {
        public void serializeCustom(JsonObject object, FOTLootItem context, JsonSerializationContext conditions) {
            super.m_7219_(object, (LootPoolSingletonContainer)context, conditions);
            ResourceLocation resourceLocation = Registry.f_122827_.m_7981_((Object)context.item);
            if (resourceLocation == null) {
                throw new IllegalArgumentException("Can't serialize unknown item " + context.item);
            }
            object.addProperty("name", resourceLocation.toString());
        }

        protected FOTLootItem deserialize(JsonObject object, JsonDeserializationContext context, int weight, int quality, LootItemCondition[] conditions, LootItemFunction[] functions) {
            Item item = GsonHelper.m_13909_((JsonObject)object, (String)"name");
            return new FOTLootItem(item, weight, quality, conditions, functions);
        }
    }
}

