/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.mixin.animal;

import com.stevekung.fishofthieves.entity.PartyFish;
import com.stevekung.fishofthieves.entity.listener.FishJukeboxListener;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.EntityPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractFish.class})
public abstract class MixinAbstractFish
extends WaterAnimal
implements PartyFish {
    @Unique
    private static final EntityDataAccessor<Boolean> DATA_DANCING = SynchedEntityData.m_135353_(AbstractFish.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    @Unique
    @Nullable
    private BlockPos jukeboxPos;
    @Unique
    private DynamicGameEventListener<FishJukeboxListener> dynamicJukeboxListener;

    MixinAbstractFish() {
        super(null, null);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void fishofthieves$init(EntityType<? extends AbstractFish> entityType, Level level, CallbackInfo info) {
        EntityPositionSource positionSource = new EntityPositionSource((Entity)this, this.m_20192_());
        this.dynamicJukeboxListener = new DynamicGameEventListener((GameEventListener)new FishJukeboxListener(this, (PositionSource)positionSource, GameEvent.f_238690_.m_157827_()));
    }

    @Inject(method={"aiStep"}, at={@At(value="HEAD")})
    private void fishofthieves$checkNearbyJukebox(CallbackInfo info) {
        if (this.isDancing() && this.shouldStopDancing() && this.f_19797_ % 20 == 0) {
            this.setDancing(false);
            this.jukeboxPos = null;
        }
    }

    @Inject(method={"defineSynchedData"}, at={@At(value="TAIL")})
    private void fishofthieves$addSyncedData(CallbackInfo info) {
        this.f_19804_.m_135372_(DATA_DANCING, (Object)false);
    }

    public void m_213651_(BiConsumer<DynamicGameEventListener<?>, ServerLevel> consumer) {
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            consumer.accept(this.dynamicJukeboxListener, serverLevel);
        }
    }

    @Override
    public void setJukeboxPlaying(BlockPos jukeboxPos, boolean jukeboxPlaying) {
        if (jukeboxPlaying) {
            if (!this.isDancing()) {
                this.jukeboxPos = jukeboxPos;
                this.setDancing(true);
            }
        } else if (jukeboxPos.equals((Object)this.jukeboxPos) || this.jukeboxPos == null) {
            this.jukeboxPos = null;
            this.setDancing(false);
        }
    }

    @Override
    public boolean isDancing() {
        return (Boolean)this.f_19804_.m_135370_(DATA_DANCING);
    }

    private void setDancing(boolean dancing) {
        if (this.f_19853_.f_46443_) {
            return;
        }
        this.f_19804_.m_135381_(DATA_DANCING, (Object)dancing);
    }

    private boolean shouldStopDancing() {
        return this.jukeboxPos == null || !this.jukeboxPos.m_203195_((Position)this.m_20182_(), (double)GameEvent.f_238690_.m_157827_()) || !this.f_19853_.m_8055_(this.jukeboxPos).m_60713_(Blocks.f_50131_);
    }
}

