/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.trigger;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.stevekung.fishofthieves.FishOfThieves;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;

public class ItemUsedOnBlockWithNearbyEntityTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    static final ResourceLocation ID = FishOfThieves.res("item_used_on_block_with_nearby_entity");

    public ResourceLocation m_7295_() {
        return ID;
    }

    public TriggerInstance createInstance(JsonObject json, EntityPredicate.Composite entityPredicate, DeserializationContext conditionsParser) {
        LocationPredicate locationPredicate = LocationPredicate.m_52629_((JsonElement)json.get("location"));
        ItemPredicate itemPredicate = ItemPredicate.m_45051_((JsonElement)json.get("item"));
        EntityPredicate.Composite composite = EntityPredicate.Composite.m_36677_((JsonObject)json, (String)"entity", (DeserializationContext)conditionsParser);
        return new TriggerInstance(entityPredicate, locationPredicate, itemPredicate, composite);
    }

    public void trigger(ServerPlayer player, BlockPos pos, ItemStack stack, Entity entity) {
        BlockState blockState = player.m_9236_().m_8055_(pos);
        LootContext lootContext = EntityPredicate.m_36616_((ServerPlayer)player, (Entity)entity);
        this.m_66234_(player, triggerInstance -> triggerInstance.matches(blockState, player.m_9236_(), pos, stack, lootContext));
    }

    public static class TriggerInstance
    extends AbstractCriterionTriggerInstance {
        private final LocationPredicate location;
        private final ItemPredicate item;
        private final EntityPredicate.Composite entity;

        public TriggerInstance(EntityPredicate.Composite composite, LocationPredicate locationPredicate, ItemPredicate itemPredicate, EntityPredicate.Composite entity) {
            super(ID, composite);
            this.location = locationPredicate;
            this.item = itemPredicate;
            this.entity = entity;
        }

        public static TriggerInstance itemUsedOnBlock(LocationPredicate.Builder locationBuilder, ItemPredicate.Builder stackBuilder, EntityPredicate.Composite entity) {
            return new TriggerInstance(EntityPredicate.Composite.f_36667_, locationBuilder.m_52658_(), stackBuilder.m_45077_(), entity);
        }

        public boolean matches(BlockState state, ServerLevel level, BlockPos pos, ItemStack stack, LootContext lootContext) {
            if (!this.location.m_52617_(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5)) {
                return false;
            }
            return this.item.m_45049_(stack) || this.entity.m_36681_(lootContext);
        }

        public JsonObject m_7683_(SerializationContext context) {
            JsonObject jsonObject = super.m_7683_(context);
            jsonObject.add("location", this.location.m_52616_());
            jsonObject.add("item", this.item.m_45048_());
            jsonObject.add("entity", this.entity.m_36675_(context));
            return jsonObject;
        }
    }
}

