/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.entity.animal;

import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.entity.AbstractThievesFish;
import com.stevekung.fishofthieves.entity.variant.IslehopperVariant;
import com.stevekung.fishofthieves.registry.FOTDataSerializers;
import com.stevekung.fishofthieves.registry.FOTItems;
import com.stevekung.fishofthieves.registry.FOTRegistry;
import com.stevekung.fishofthieves.registry.FOTSoundEvents;
import com.stevekung.fishofthieves.registry.FOTTags;
import com.stevekung.fishofthieves.registry.variant.IslehopperVariants;
import com.stevekung.fishofthieves.utils.Continentalness;
import com.stevekung.fishofthieves.utils.PeakTypes;
import com.stevekung.fishofthieves.utils.TerrainUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;

public class Islehopper
extends AbstractThievesFish<IslehopperVariant> {
    private static final EntityDataAccessor<IslehopperVariant> VARIANT = SynchedEntityData.m_135353_(Islehopper.class, FOTDataSerializers.ISLEHOPPER_VARIANT);
    public static final Consumer<Int2ObjectOpenHashMap<String>> DATA_FIX_MAP = map -> {
        map.defaultReturnValue((Object)"fishofthieves:stone");
        map.put(0, (Object)"fishofthieves:stone");
        map.put(1, (Object)"fishofthieves:moss");
        map.put(2, (Object)"fishofthieves:honey");
        map.put(3, (Object)"fishofthieves:raven");
        map.put(4, (Object)"fishofthieves:amethyst");
    };

    public Islehopper(EntityType<? extends Islehopper> entityType, Level level) {
        super(entityType, level);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.25, WORMS, false));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)IslehopperVariants.STONE);
    }

    @Override
    public Registry<IslehopperVariant> getRegistry() {
        return FOTRegistry.ISLEHOPPER_VARIANT;
    }

    @Override
    public void setVariant(IslehopperVariant variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    @Override
    public IslehopperVariant getVariant() {
        return (IslehopperVariant)this.f_19804_.m_135370_(VARIANT);
    }

    @Override
    public Holder<IslehopperVariant> getSpawnVariant(boolean fromBucket) {
        return this.getSpawnVariant((LivingEntity)this, FOTTags.FishVariant.DEFAULT_ISLEHOPPER_SPAWNS, IslehopperVariants.STONE, fromBucket);
    }

    @Override
    public Consumer<Int2ObjectOpenHashMap<String>> getDataFix() {
        return DATA_FIX_MAP;
    }

    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)FOTItems.ISLEHOPPER_BUCKET);
    }

    protected SoundEvent m_5592_() {
        return FOTSoundEvents.ISLEHOPPER_DEATH;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return FOTSoundEvents.ISLEHOPPER_HURT;
    }

    protected SoundEvent m_5699_() {
        return FOTSoundEvents.ISLEHOPPER_FLOP;
    }

    public boolean m_7313_(Entity entity) {
        if (FishOfThieves.CONFIG.general.neutralFishBehavior) {
            int multiplier;
            int n = multiplier = this.isTrophy() ? 2 : 1;
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                if (entity.m_6469_(DamageSource.m_19370_((LivingEntity)this), (float)multiplier)) {
                    if (!this.m_20067_()) {
                        serverPlayer.f_8906_.m_9829_((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.f_132162_, 0.0f));
                    }
                    serverPlayer.m_147207_(new MobEffectInstance(MobEffects.f_19614_, 60 * multiplier, 0), (Entity)this);
                }
            }
        }
        return false;
    }

    public EntityDimensions m_6972_(Pose pose) {
        return this.isTrophy() ? super.m_6972_(pose) : EntityDimensions.m_20398_((float)0.3f, (float)0.2f);
    }

    protected float m_6431_(Pose pose, EntityDimensions size) {
        return this.isTrophy() ? 0.29f : 0.15f;
    }

    @Override
    public float getGlowBrightness(float ageInTicks) {
        return Mth.m_14036_((float)(1.0f + Mth.m_14089_((float)(ageInTicks * 0.05f))), (float)0.5f, (float)1.0f);
    }

    @Override
    public boolean isFood(ItemStack itemStack) {
        return WORMS.test(itemStack);
    }

    public static boolean checkSpawnRules(EntityType<? extends WaterAnimal> entityType, ServerLevelAccessor level, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource random) {
        boolean isSurfaceWater = WaterAnimal.m_218282_(entityType, (LevelAccessor)level, (MobSpawnType)mobSpawnType, (BlockPos)blockPos, (RandomSource)random);
        boolean isWater = level.m_6425_(blockPos.m_7495_()).m_205070_(FluidTags.f_13131_) && level.m_8055_(blockPos.m_7494_()).m_60713_(Blocks.f_49990_);
        Continentalness continentalness = TerrainUtils.getContinentalness(level.m_6018_(), blockPos);
        PeakTypes peakTypes = TerrainUtils.getPeakTypes(level.m_6018_(), blockPos);
        if (level.m_204166_(blockPos).m_203656_(FOTTags.Biomes.ISLEHOPPER_SPAWN_AT_COAST)) {
            return !(!isSurfaceWater || peakTypes != PeakTypes.LOW && peakTypes != PeakTypes.MID || continentalness != Continentalness.COAST && continentalness != Continentalness.OCEAN);
        }
        return isWater && blockPos.m_123342_() <= 0;
    }
}

