/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.loot.predicate;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.stevekung.fishofthieves.utils.Continentalness;
import com.stevekung.fishofthieves.utils.TerrainUtils;
import java.util.Iterator;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.structure.Structure;
import org.jetbrains.annotations.Nullable;

public record FOTLocationPredicate(TagKey<Biome> biome, TagKey<Structure> structure, Continentalness continentalness, Boolean hasRaids) {
    public static final FOTLocationPredicate ANY = new FOTLocationPredicate(null, null, null, null);

    public boolean matches(ServerLevel level, double x, double y, double z) {
        BlockPos blockPos = new BlockPos(x, y, z);
        boolean loaded = level.m_46749_(blockPos);
        boolean isRaided = level.m_8843_(blockPos);
        Optional structureFeatureHolderSet = level.m_8891_().m_175515_(Registries.f_256944_).m_203431_(this.structure);
        return (this.biome == null || loaded && level.m_204166_(blockPos).m_203656_(this.biome)) && (this.structure == null || structureFeatureHolderSet.isEmpty() || structureFeatureHolderSet.isPresent() && loaded && this.structureMatched(level, blockPos, (HolderSet.Named<Structure>)((HolderSet.Named)structureFeatureHolderSet.get()))) && (this.continentalness == null || loaded && this.continentalness == TerrainUtils.getContinentalness(level, blockPos)) && (this.hasRaids == null || loaded && this.hasRaids == isRaided);
    }

    private boolean structureMatched(ServerLevel level, BlockPos blockPos, HolderSet.Named<Structure> holders) {
        Iterator iterator = holders.iterator();
        if (iterator.hasNext()) {
            Holder holder = (Holder)iterator.next();
            return level.m_215010_().m_220524_(blockPos, (Structure)holder.m_203334_()).m_73603_();
        }
        return false;
    }

    public JsonElement serializeToJson() {
        if (this == ANY) {
            return JsonNull.INSTANCE;
        }
        JsonObject jsonObject = new JsonObject();
        if (this.biome != null) {
            jsonObject.addProperty("biome", this.biome.f_203868_().toString());
        }
        if (this.structure != null) {
            jsonObject.addProperty("structure", this.structure.f_203868_().toString());
        }
        if (this.continentalness != null) {
            jsonObject.addProperty("continentalness", this.continentalness.m_7912_());
        }
        if (this.hasRaids != null) {
            jsonObject.addProperty("hasRaids", this.hasRaids);
        }
        return jsonObject;
    }

    public static FOTLocationPredicate fromJson(@Nullable JsonElement json) {
        String string;
        if (json == null || json.isJsonNull()) {
            return ANY;
        }
        JsonObject jsonObject = GsonHelper.m_13918_((JsonElement)json, (String)"location");
        TagKey biome = null;
        TagKey structure = null;
        Continentalness continentalness = null;
        Boolean hasRaids = null;
        if (jsonObject.has("biome")) {
            string = GsonHelper.m_13906_((JsonObject)jsonObject, (String)"biome");
            biome = TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation(string));
        }
        if (jsonObject.has("structure")) {
            string = GsonHelper.m_13906_((JsonObject)jsonObject, (String)"structure");
            structure = TagKey.m_203882_((ResourceKey)Registries.f_256944_, (ResourceLocation)new ResourceLocation(string));
        }
        if (jsonObject.has("continentalness")) {
            continentalness = Continentalness.byName(GsonHelper.m_13906_((JsonObject)jsonObject, (String)"continentalness"));
        }
        if (jsonObject.has("hasRaids")) {
            hasRaids = GsonHelper.m_13912_((JsonObject)jsonObject, (String)"hasRaids");
        }
        return new FOTLocationPredicate((TagKey<Biome>)biome, (TagKey<Structure>)structure, continentalness, hasRaids);
    }

    public static class Builder {
        @Nullable
        private TagKey<Biome> biome;
        @Nullable
        private TagKey<Structure> structure;
        @Nullable
        private Continentalness continentalness;
        @Nullable
        private Boolean hasRaids;

        public static Builder location() {
            return new Builder();
        }

        public Builder setBiome(@Nullable TagKey<Biome> biome) {
            this.biome = biome;
            return this;
        }

        public Builder setStructure(@Nullable TagKey<Structure> structure) {
            this.structure = structure;
            return this;
        }

        public Builder setContinentalness(@Nullable Continentalness continentalness) {
            this.continentalness = continentalness;
            return this;
        }

        public Builder hasRaids() {
            this.hasRaids = true;
            return this;
        }

        public FOTLocationPredicate build() {
            return new FOTLocationPredicate(this.biome, this.structure, this.continentalness, this.hasRaids);
        }
    }
}

