/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.registry.variant;

import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.entity.variant.SplashtailVariant;
import com.stevekung.fishofthieves.registry.FOTRegistry;
import com.stevekung.fishofthieves.spawn.SpawnSelectors;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;

public class SplashtailVariants {
    public static final SplashtailVariant RUBY = SplashtailVariant.builder().condition(SpawnSelectors.always()).texture("ruby").build();
    public static final SplashtailVariant SUNNY = SplashtailVariant.builder().condition(SpawnSelectors.simpleSpawn(SpawnSelectors.dayAndSeeSky())).texture("sunny").build();
    public static final SplashtailVariant INDIGO = SplashtailVariant.builder().condition(SpawnSelectors.always()).texture("indigo").build();
    public static final SplashtailVariant UMBER = SplashtailVariant.builder().condition(SpawnSelectors.probability(FishOfThieves.CONFIG.spawnRate.variant.umberSplashtailProbability)).texture("umber").build();
    public static final SplashtailVariant SEAFOAM = SplashtailVariant.builder().condition(SpawnSelectors.nightAndSeeSky()).texture("seafoam").glowTexture("seafoam_glow").build();

    public static void init() {
        SplashtailVariants.register("ruby", RUBY);
        SplashtailVariants.register("sunny", SUNNY);
        SplashtailVariants.register("indigo", INDIGO);
        SplashtailVariants.register("umber", UMBER);
        SplashtailVariants.register("seafoam", SEAFOAM);
    }

    private static void register(String key, SplashtailVariant variant) {
        Registry.m_122965_(FOTRegistry.SPLASHTAIL_VARIANT, (ResourceLocation)FishOfThieves.res(key), (Object)variant);
    }
}

