/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.utils;

import com.stevekung.fishofthieves.utils.Continentalness;
import com.stevekung.fishofthieves.utils.PeakTypes;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.QuartPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.OverworldBiomeBuilder;
import net.minecraft.world.level.levelgen.NoiseRouterData;
import net.minecraft.world.level.levelgen.structure.Structure;

public class TerrainUtils {
    private static final OverworldBiomeBuilder OVERWORLD_BUILDER = new OverworldBiomeBuilder();

    public static Continentalness getContinentalness(ServerLevel level, BlockPos blockPos) {
        float continentalness = Climate.m_186796_((long)TerrainUtils.getTargetPoint(level, blockPos).f_187005_());
        return Continentalness.byName(OVERWORLD_BUILDER.m_187189_((double)continentalness));
    }

    public static PeakTypes getPeakTypes(ServerLevel level, BlockPos blockPos) {
        float weirdness = Climate.m_186796_((long)TerrainUtils.getTargetPoint(level, blockPos).f_187008_());
        float peakTypes = NoiseRouterData.m_224435_((float)weirdness);
        return PeakTypes.byName(OverworldBiomeBuilder.m_187155_((double)peakTypes));
    }

    public static boolean isInFeature(ServerLevel level, BlockPos blockPos, TagKey<Structure> tagKey) {
        return level.m_215010_().m_220491_(blockPos, tagKey).m_73603_();
    }

    public static boolean isInFeature(ServerLevel level, BlockPos blockPos, ResourceKey<Structure> resourceKey) {
        return level.m_215010_().m_220488_(blockPos, resourceKey).m_73603_();
    }

    public static Optional<BlockPos> lookForBlock(BlockPos blockPos, int range, Predicate<BlockPos> posFilter) {
        return BlockPos.m_121930_((BlockPos)blockPos, (int)range, (int)range, posFilter);
    }

    public static boolean lookForBlocksWithSize(BlockPos blockPos, int range, int maxSize, Predicate<BlockPos> posFilter) {
        int size = 0;
        for (BlockPos blockPos2 : BlockPos.m_121925_((BlockPos)blockPos, (int)range, (int)range, (int)range)) {
            if (!posFilter.test(blockPos2) || ++size < maxSize) continue;
            return true;
        }
        return false;
    }

    private static Climate.TargetPoint getTargetPoint(ServerLevel level, BlockPos blockPos) {
        int chunkX = QuartPos.m_175400_((int)blockPos.m_123341_());
        int chunkY = QuartPos.m_175400_((int)blockPos.m_123342_());
        int chunkZ = QuartPos.m_175400_((int)blockPos.m_123343_());
        return Objects.requireNonNullElseGet(level.m_7726_().m_214994_().m_224579_(), Climate::m_207841_).m_183445_(chunkX, chunkY, chunkZ);
    }
}

