/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.loot.function;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.stevekung.fishofthieves.registry.FOTLootItemFunctions;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_117;
import net.minecraft.class_120;
import net.minecraft.class_156;
import net.minecraft.class_1767;
import net.minecraft.class_1781;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3518;
import net.minecraft.class_47;
import net.minecraft.class_5339;
import net.minecraft.class_5341;
import net.minecraft.class_5819;

public class SetRandomFireworkFunction
extends class_120 {
    private final List<Integer> fireworkColors;

    SetRandomFireworkFunction(class_5341[] lootItemConditions, List<Integer> fireworkColors) {
        super(lootItemConditions);
        this.fireworkColors = ImmutableList.copyOf(fireworkColors);
    }

    public class_5339 method_29321() {
        return FOTLootItemFunctions.SET_RANDOM_FIREWORK;
    }

    public class_1799 method_522(class_1799 itemStack, class_47 context) {
        if (itemStack.method_31574(class_1802.field_8639) && !this.fireworkColors.isEmpty()) {
            class_5819 random = context.method_294();
            class_2487 compoundTag = itemStack.method_7911("Fireworks");
            class_2499 listTag = new class_2499();
            class_2487 explosionTag = new class_2487();
            boolean flicker = random.method_43056();
            boolean trail = random.method_43056();
            if (flicker) {
                explosionTag.method_10556("Flicker", flicker);
            }
            if (trail) {
                explosionTag.method_10556("Trail", trail);
            }
            explosionTag.method_10572("Colors", List.of((Integer)class_156.method_32309(this.fireworkColors, (class_5819)random)));
            explosionTag.method_10572("FadeColors", List.of(Integer.valueOf(class_1767.field_7952.method_7790())));
            explosionTag.method_10567("Type", (byte)((class_1781.class_1782)class_156.method_27173((Object[])class_1781.class_1782.values(), (class_5819)random)).method_7816());
            listTag.add((Object)explosionTag);
            compoundTag.method_10567("Flight", (byte)(1 + random.method_43048(3)));
            compoundTag.method_10566("Explosions", (class_2520)listTag);
        }
        return itemStack;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends class_120.class_121<Builder> {
        private final List<Integer> fireworkColors = Lists.newArrayList();

        protected Builder getThis() {
            return this;
        }

        public Builder withColor(class_1767 color) {
            this.fireworkColors.add(color.method_7790());
            return this;
        }

        public Builder withColor(int color) {
            this.fireworkColors.add(color);
            return this;
        }

        public class_117 method_515() {
            return new SetRandomFireworkFunction(this.method_526(), this.fireworkColors);
        }
    }

    public static class Serializer
    extends class_120.class_123<SetRandomFireworkFunction> {
        public void serialize(JsonObject json, SetRandomFireworkFunction value, JsonSerializationContext serializationContext) {
            super.method_529(json, (class_120)value, serializationContext);
            if (!value.fireworkColors.isEmpty()) {
                JsonArray jsonArray = new JsonArray();
                for (Integer fireworkColor : value.fireworkColors) {
                    jsonArray.add(serializationContext.serialize((Object)fireworkColor));
                }
                json.add("colors", (JsonElement)jsonArray);
            }
        }

        public SetRandomFireworkFunction deserialize(JsonObject object, JsonDeserializationContext deserializationContext, class_5341[] conditions) {
            ArrayList fireworkColors = Lists.newArrayList();
            if (object.has("colors")) {
                for (JsonElement jsonElement : class_3518.method_15261((JsonObject)object, (String)"colors")) {
                    fireworkColors.add(jsonElement.getAsInt());
                }
            }
            return new SetRandomFireworkFunction(conditions, fireworkColors);
        }
    }
}

