/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.entity;

import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.entity.FishData;
import com.stevekung.fishofthieves.entity.ThievesFish;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.AbstractSchoolingFish;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSchoolingThievesFish<T extends FishData>
extends AbstractSchoolingFish
implements ThievesFish<T> {
    private static final EntityDataAccessor<Boolean> TROPHY = SynchedEntityData.m_135353_(AbstractSchoolingThievesFish.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> HAS_FED = SynchedEntityData.m_135353_(AbstractSchoolingThievesFish.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> NO_FLIP = SynchedEntityData.m_135353_(AbstractSchoolingThievesFish.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public AbstractSchoolingThievesFish(EntityType<? extends AbstractSchoolingFish> entityType, Level level) {
        super(entityType, level);
        this.m_6210_();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TROPHY, (Object)false);
        this.f_19804_.m_135372_(HAS_FED, (Object)false);
        this.f_19804_.m_135372_(NO_FLIP, (Object)false);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128359_("variant", this.getRegistry().m_7981_((Object)this.getVariant()).toString());
        compound.m_128379_("Trophy", this.isTrophy());
        compound.m_128379_("HasFed", this.hasFed());
        compound.m_128379_("NoFlip", this.isNoFlip());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        ThievesFish.fixData(compound, this.getDataFix());
        FishData variant = (FishData)this.getRegistry().m_7745_(ResourceLocation.m_135820_((String)compound.m_128461_("variant")));
        if (variant != null) {
            this.setVariant(variant);
        }
        this.setTrophy(compound.m_128471_("Trophy"));
        this.setHasFed(compound.m_128471_("HasFed"));
        this.setNoFlip(compound.m_128471_("NoFlip"));
    }

    public void m_6872_(ItemStack itemStack) {
        super.m_6872_(itemStack);
        this.saveToBucket(itemStack.m_41784_());
    }

    public void m_142278_(CompoundTag compound) {
        super.m_142278_(compound);
        this.loadFromBucket(compound);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (this.isFood(itemStack) && !this.isTrophy() && !this.hasFed()) {
            if (!this.f_19853_.f_46443_) {
                this.growUp(player, itemStack);
            }
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123748_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 0.0, 0.0, 0.0);
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        spawnData = super.m_6518_(level, difficulty, reason, spawnData, dataTag);
        return this.defaultFinalizeSpawn((LivingEntity)this, reason, spawnData, dataTag);
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        if (TROPHY.equals(key)) {
            this.m_6210_();
        }
        super.m_7350_(key);
    }

    @Override
    public boolean isTrophy() {
        return (Boolean)this.f_19804_.m_135370_(TROPHY);
    }

    @Override
    public void setTrophy(boolean trophy) {
        if (trophy) {
            this.m_21051_(Attributes.f_22276_).m_22100_((double)FishOfThieves.CONFIG.general.trophyMaxHealth);
        }
        this.f_19804_.m_135381_(TROPHY, (Object)trophy);
    }

    @Override
    public boolean hasFed() {
        return (Boolean)this.f_19804_.m_135370_(HAS_FED);
    }

    @Override
    public void setHasFed(boolean hasFed) {
        this.f_19804_.m_135381_(HAS_FED, (Object)hasFed);
    }

    @Override
    public void setNoFlip(boolean noFlip) {
        this.f_19804_.m_135381_(NO_FLIP, (Object)noFlip);
    }

    @Override
    public boolean isNoFlip() {
        return (Boolean)this.f_19804_.m_135370_(NO_FLIP);
    }

    private void growUp(Player player, ItemStack itemStack) {
        if (!player.m_150110_().f_35937_) {
            itemStack.m_41774_(1);
        }
        if (this.f_19796_.m_188503_(10) == 0) {
            this.setTrophy(true);
            this.setHasFed(true);
            this.m_21153_(FishOfThieves.CONFIG.general.trophyMaxHealth);
        }
    }
}

