/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.registry.variant;

import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.entity.variant.DevilfishVariant;
import com.stevekung.fishofthieves.registry.FOTRegistry;
import com.stevekung.fishofthieves.registry.FOTTags;
import com.stevekung.fishofthieves.spawn.SpawnSelectors;
import com.stevekung.fishofthieves.utils.TerrainUtils;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;

public class DevilfishVariants {
    public static final DevilfishVariant ASHEN = DevilfishVariant.builder().condition(SpawnSelectors.always()).texture("ashen").build();
    public static final DevilfishVariant SEASHELL = DevilfishVariant.builder().condition(SpawnSelectors.always()).texture("seashell").build();
    public static final DevilfishVariant LAVA = DevilfishVariant.builder().condition(SpawnSelectors.simpleSpawn(context -> TerrainUtils.lookForBlock(context.blockPos(), 4, blockPos2 -> context.level().m_6425_(blockPos2).m_205070_(FluidTags.f_13132_) && context.level().m_6425_(blockPos2).m_76170_()).isPresent())).texture("lava").build();
    public static final DevilfishVariant FORSAKEN = DevilfishVariant.builder().condition(SpawnSelectors.probability(FishOfThieves.CONFIG.spawnRate.variant.forsakenDevilfishProbability)).texture("forsaken").build();
    public static final DevilfishVariant FIRELIGHT = DevilfishVariant.builder().condition(SpawnSelectors.simpleSpawn(true, context -> {
        Optional<BlockPos> optional = TerrainUtils.lookForBlock(context.blockPos(), 4, blockPos2 -> context.level().m_8055_(blockPos2).m_204336_(FOTTags.Blocks.FIRELIGHT_DEVILFISH_WARM_BLOCKS) || context.level().m_6425_(blockPos2).m_205070_(FluidTags.f_13132_) && context.level().m_6425_(blockPos2).m_76170_());
        return context.isNight() && optional.isPresent();
    })).texture("firelight").glowTexture("firelight_glow").build();

    public static void init() {
        DevilfishVariants.register("ashen", ASHEN);
        DevilfishVariants.register("seashell", SEASHELL);
        DevilfishVariants.register("lava", LAVA);
        DevilfishVariants.register("forsaken", FORSAKEN);
        DevilfishVariants.register("firelight", FIRELIGHT);
    }

    private static void register(String key, DevilfishVariant variant) {
        Registry.m_122965_(FOTRegistry.DEVILFISH_VARIANT, (ResourceLocation)FishOfThieves.res(key), (Object)variant);
    }
}

