/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves;

import com.mojang.logging.LogUtils;
import com.stevekung.fishofthieves.api.block.FishPlaqueRegistry;
import com.stevekung.fishofthieves.api.block.FishPlaqueTagConverter;
import com.stevekung.fishofthieves.config.FishOfThievesConfig;
import com.stevekung.fishofthieves.registry.FOTCriteriaTriggers;
import com.stevekung.fishofthieves.registry.FOTDataSerializers;
import com.stevekung.fishofthieves.registry.FOTDisplayItems;
import com.stevekung.fishofthieves.registry.FOTEntitySubPredicate;
import com.stevekung.fishofthieves.registry.FOTItems;
import com.stevekung.fishofthieves.registry.FOTLootItemFunctions;
import com.stevekung.fishofthieves.registry.FOTLootPoolEntries;
import com.stevekung.fishofthieves.registry.FOTSoundEvents;
import com.stevekung.fishofthieves.registry.FOTStructures;
import com.stevekung.fishofthieves.utils.FOTPlatform;
import java.util.List;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.DispenserBlock;
import org.slf4j.Logger;

public class FishOfThieves {
    public static final String MOD_ID = "fishofthieves";
    public static final String MOD_RESOURCES = "fishofthieves:";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static FishOfThievesConfig CONFIG;
    public static final ResourceKey<CreativeModeTab> FOT;

    public static ResourceLocation res(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    public static void init() {
        FOTSoundEvents.init();
        FOTCriteriaTriggers.init();
        FOTDataSerializers.init();
    }

    public static void registerConfig() {
        AutoConfig.register(FishOfThievesConfig.class, GsonConfigSerializer::new);
        CONFIG = (FishOfThievesConfig)AutoConfig.getConfigHolder(FishOfThievesConfig.class).getConfig();
    }

    public static void initCommon() {
        FOTDataSerializers.init();
        FOTLootItemFunctions.init();
        FOTLootPoolEntries.init();
        FOTStructures.init();
        FOTEntitySubPredicate.init();
        FishPlaqueRegistry.registerTagConverter(EntityType.f_20489_, FishPlaqueTagConverter.TROPICAL_FISH);
        if (FOTPlatform.isModLoaded("naturalist")) {
            FishPlaqueRegistry.registerInteractionItem("naturalist:snail", Items.f_42446_);
        }
        if (FOTPlatform.isModLoaded("alexsmobs")) {
            FishPlaqueRegistry.registerInteractionItem("alexsmobs:cosmic_cod", Items.f_42446_);
            FishPlaqueRegistry.registerInteractionItem("alexsmobs:stradpole", Items.f_42448_);
        }
        DispenseItemBehavior bucket = (DispenseItemBehavior)DispenserBlock.f_52661_.get(Items.f_42447_);
        DispenserBlock.m_52672_((ItemLike)FOTItems.SPLASHTAIL_BUCKET, (DispenseItemBehavior)bucket);
        DispenserBlock.m_52672_((ItemLike)FOTItems.PONDIE_BUCKET, (DispenseItemBehavior)bucket);
        DispenserBlock.m_52672_((ItemLike)FOTItems.ISLEHOPPER_BUCKET, (DispenseItemBehavior)bucket);
        DispenserBlock.m_52672_((ItemLike)FOTItems.ANCIENTSCALE_BUCKET, (DispenseItemBehavior)bucket);
        DispenserBlock.m_52672_((ItemLike)FOTItems.PLENTIFIN_BUCKET, (DispenseItemBehavior)bucket);
        DispenserBlock.m_52672_((ItemLike)FOTItems.WILDSPLASH_BUCKET, (DispenseItemBehavior)bucket);
        DispenserBlock.m_52672_((ItemLike)FOTItems.DEVILFISH_BUCKET, (DispenseItemBehavior)bucket);
        DispenserBlock.m_52672_((ItemLike)FOTItems.BATTLEGILL_BUCKET, (DispenseItemBehavior)bucket);
        DispenserBlock.m_52672_((ItemLike)FOTItems.WRECKER_BUCKET, (DispenseItemBehavior)bucket);
        DispenserBlock.m_52672_((ItemLike)FOTItems.STORMFISH_BUCKET, (DispenseItemBehavior)bucket);
    }

    public static List<VillagerTrades.ItemListing> getFishermanTradesByLevel(int level, List<VillagerTrades.ItemListing> list) {
        switch (level) {
            case 1: {
                list.add((VillagerTrades.ItemListing)new VillagerTrades.ItemsAndEmeraldsToItems((ItemLike)FOTItems.SPLASHTAIL, 6, FOTItems.COOKED_SPLASHTAIL, 6, 8, 1));
                list.add((VillagerTrades.ItemListing)new VillagerTrades.ItemsAndEmeraldsToItems((ItemLike)FOTItems.PONDIE, 6, FOTItems.COOKED_PONDIE, 6, 8, 1));
                list.add((VillagerTrades.ItemListing)new VillagerTrades.ItemsAndEmeraldsToItems((ItemLike)FOTItems.ISLEHOPPER, 2, 2, FOTItems.COOKED_ISLEHOPPER, 2, 8, 2));
                list.add((VillagerTrades.ItemListing)new VillagerTrades.ItemsAndEmeraldsToItems((ItemLike)FOTItems.ANCIENTSCALE, 3, FOTItems.COOKED_ANCIENTSCALE, 3, 5, 3));
                list.add((VillagerTrades.ItemListing)new VillagerTrades.EmeraldForItems((ItemLike)FOTItems.EARTHWORMS, 48, 8, 10));
                list.add((VillagerTrades.ItemListing)new VillagerTrades.EmeraldForItems((ItemLike)FOTItems.GRUBS, 32, 8, 12));
                list.add((VillagerTrades.ItemListing)new VillagerTrades.EmeraldForItems((ItemLike)FOTItems.LEECHES, 24, 8, 14));
                list.add((VillagerTrades.ItemListing)new VillagerTrades.ItemsForEmeralds(FOTItems.SPLASHTAIL_BUCKET, 3, 1, 16, 1));
                list.add((VillagerTrades.ItemListing)new VillagerTrades.ItemsForEmeralds(FOTItems.PONDIE_BUCKET, 3, 1, 16, 1));
                list.add((VillagerTrades.ItemListing)new VillagerTrades.ItemsForEmeralds(FOTItems.ISLEHOPPER_BUCKET, 3, 1, 16, 1));
                list.add((VillagerTrades.ItemListing)new VillagerTrades.ItemsForEmeralds(FOTItems.ANCIENTSCALE_BUCKET, 3, 1, 16, 1));
                break;
            }
            case 2: {
                list.add((VillagerTrades.ItemListing)new VillagerTrades.EmeraldForItems((ItemLike)FOTItems.SPLASHTAIL, 12, 8, 12));
                list.add((VillagerTrades.ItemListing)new VillagerTrades.EmeraldForItems((ItemLike)FOTItems.PONDIE, 12, 8, 12));
                list.add((VillagerTrades.ItemListing)new VillagerTrades.EmeraldForItems((ItemLike)FOTItems.ISLEHOPPER, 8, 8, 15));
                list.add((VillagerTrades.ItemListing)new VillagerTrades.EmeraldForItems((ItemLike)FOTItems.ANCIENTSCALE, 8, 9, 15));
                list.add((VillagerTrades.ItemListing)new VillagerTrades.ItemsAndEmeraldsToItems((ItemLike)FOTItems.PLENTIFIN, 3, 2, FOTItems.COOKED_PLENTIFIN, 3, 5, 3));
                list.add((VillagerTrades.ItemListing)new VillagerTrades.ItemsAndEmeraldsToItems((ItemLike)FOTItems.WILDSPLASH, 4, 2, FOTItems.COOKED_WILDSPLASH, 4, 6, 3));
                list.add((VillagerTrades.ItemListing)new VillagerTrades.ItemsAndEmeraldsToItems((ItemLike)FOTItems.DEVILFISH, 4, 3, FOTItems.COOKED_DEVILFISH, 4, 6, 4));
                list.add((VillagerTrades.ItemListing)new VillagerTrades.ItemsForEmeralds(FOTItems.PLENTIFIN_BUCKET, 3, 1, 16, 1));
                list.add((VillagerTrades.ItemListing)new VillagerTrades.ItemsForEmeralds(FOTItems.WILDSPLASH_BUCKET, 3, 1, 16, 1));
                list.add((VillagerTrades.ItemListing)new VillagerTrades.ItemsForEmeralds(FOTItems.DEVILFISH_BUCKET, 3, 1, 16, 1));
                break;
            }
            case 3: {
                list.add((VillagerTrades.ItemListing)new VillagerTrades.EmeraldForItems((ItemLike)FOTItems.PLENTIFIN, 8, 9, 17));
                list.add((VillagerTrades.ItemListing)new VillagerTrades.EmeraldForItems((ItemLike)FOTItems.WILDSPLASH, 8, 9, 17));
                list.add((VillagerTrades.ItemListing)new VillagerTrades.EmeraldForItems((ItemLike)FOTItems.DEVILFISH, 6, 10, 20));
                break;
            }
            case 4: {
                list.add((VillagerTrades.ItemListing)new VillagerTrades.EmeraldForItems((ItemLike)FOTItems.BATTLEGILL, 6, 10, 20));
                list.add((VillagerTrades.ItemListing)new VillagerTrades.EmeraldForItems((ItemLike)FOTItems.WRECKER, 5, 12, 25));
                list.add((VillagerTrades.ItemListing)new VillagerTrades.EmeraldForItems((ItemLike)FOTItems.STORMFISH, 5, 12, 25));
                break;
            }
            case 5: {
                list.add((VillagerTrades.ItemListing)new VillagerTrades.ItemsAndEmeraldsToItems((ItemLike)FOTItems.BATTLEGILL, 4, 3, FOTItems.COOKED_BATTLEGILL, 4, 6, 4));
                list.add((VillagerTrades.ItemListing)new VillagerTrades.ItemsAndEmeraldsToItems((ItemLike)FOTItems.WRECKER, 5, 5, FOTItems.COOKED_WRECKER, 5, 8, 5));
                list.add((VillagerTrades.ItemListing)new VillagerTrades.ItemsAndEmeraldsToItems((ItemLike)FOTItems.STORMFISH, 5, 5, FOTItems.COOKED_STORMFISH, 5, 8, 8));
                list.add((VillagerTrades.ItemListing)new VillagerTrades.ItemsForEmeralds(FOTItems.BATTLEGILL_BUCKET, 6, 1, 8, 2));
                list.add((VillagerTrades.ItemListing)new VillagerTrades.ItemsForEmeralds(FOTItems.WRECKER_BUCKET, 6, 1, 8, 2));
                list.add((VillagerTrades.ItemListing)new VillagerTrades.ItemsForEmeralds(FOTItems.STORMFISH_BUCKET, 6, 1, 8, 2));
            }
        }
        return list;
    }

    public static CreativeModeTab.Builder getCreativeTabBuilder(CreativeModeTab.Builder builder) {
        return builder.m_257941_((Component)Component.m_237115_((String)"itemGroup.fishofthieves.main")).m_257737_(() -> new ItemStack((ItemLike)FOTItems.SPLASHTAIL)).m_257501_(FOTDisplayItems::displayItems);
    }

    static {
        FOT = ResourceKey.m_135785_((ResourceKey)Registries.f_279569_, (ResourceLocation)FishOfThieves.res("fot"));
    }
}

