/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.forge.datagen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.forge.FishOfThievesForge;
import com.stevekung.fishofthieves.registry.FOTEntities;
import com.stevekung.fishofthieves.registry.FOTTags;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraftforge.common.data.DatapackBuiltinEntriesProvider;
import net.minecraftforge.common.world.ModifiableStructureInfo;
import net.minecraftforge.common.world.StructureModifier;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class FOTStructureModifiers {
    private static final Codec<TagKey<Structure>> STRUCTURE_LIST_CODEC = TagKey.m_203886_((ResourceKey)Registries.f_256944_);
    private static final RegistrySetBuilder BUILDER = new RegistrySetBuilder().m_254916_(ForgeRegistries.Keys.STRUCTURE_MODIFIERS, context -> {
        context.m_255272_(FOTStructureModifiers.key("ancientscales_spawn_in"), (Object)FOTStructureModifiers.addStructureSpawns((MobSpawnSettings.SpawnerData)FOTEntities.SpawnData.ANCIENTSCALE.m_146338_().get(0), FOTTags.Structures.ANCIENTSCALES_SPAWN_IN));
        context.m_255272_(FOTStructureModifiers.key("plentifins_spawn_in"), (Object)FOTStructureModifiers.addStructureSpawns((MobSpawnSettings.SpawnerData)FOTEntities.SpawnData.PLENTIFIN.m_146338_().get(0), FOTTags.Structures.PLENTIFINS_SPAWN_IN));
        context.m_255272_(FOTStructureModifiers.key("wreckers_spawn_in"), (Object)FOTStructureModifiers.addStructureSpawns((MobSpawnSettings.SpawnerData)FOTEntities.SpawnData.WRECKER.m_146338_().get(0), FOTTags.Structures.WRECKERS_SPAWN_IN));
        context.m_255272_(FOTStructureModifiers.key("battlegills_spawn_in"), (Object)FOTStructureModifiers.addStructureSpawns((MobSpawnSettings.SpawnerData)FOTEntities.SpawnData.BATTLEGILL.m_146338_().get(0), FOTTags.Structures.BATTLEGILLS_SPAWN_IN));
    });

    public static void generateStructureModifiers(GatherDataEvent event) {
        event.getGenerator().addProvider(event.includeServer(), output -> new StructureModifiers(output, event.getLookupProvider()));
    }

    private static StructureModifier addStructureSpawns(MobSpawnSettings.SpawnerData spawnerData, TagKey<Structure> structureTagKey) {
        return new Modifier(structureTagKey, spawnerData);
    }

    private static ResourceKey<StructureModifier> key(String key) {
        return ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.STRUCTURE_MODIFIERS, (ResourceLocation)FishOfThieves.res(key));
    }

    public record Modifier(TagKey<Structure> structureTagKey, MobSpawnSettings.SpawnerData spawnerData) implements StructureModifier
    {
        private static final RegistryObject<Codec<? extends StructureModifier>> SERIALIZER = RegistryObject.create((ResourceLocation)FishOfThievesForge.ADD_THIEVES_FISH_SPAWNS_IN_STRUCTURE_RL, (ResourceKey)ForgeRegistries.Keys.STRUCTURE_MODIFIER_SERIALIZERS, (String)"fishofthieves");

        public void modify(Holder<Structure> structure, StructureModifier.Phase phase, ModifiableStructureInfo.StructureInfo.Builder builder) {
            if (phase == StructureModifier.Phase.ADD && structure.m_203656_(this.structureTagKey)) {
                builder.getStructureSettings().getOrAddSpawnOverrides(this.spawnerData.f_48404_.m_20674_()).addSpawn(this.spawnerData);
            }
        }

        public Codec<? extends StructureModifier> codec() {
            return (Codec)SERIALIZER.get();
        }

        public static Codec<Modifier> makeCodec() {
            return RecordCodecBuilder.create(builder -> builder.group((App)STRUCTURE_LIST_CODEC.fieldOf("structure").forGetter(Modifier::structureTagKey), (App)MobSpawnSettings.SpawnerData.f_48403_.fieldOf("spawnerData").forGetter(Modifier::spawnerData)).apply((Applicative)builder, Modifier::new));
        }
    }

    private static class StructureModifiers
    extends DatapackBuiltinEntriesProvider {
        public StructureModifiers(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
            super(output, registries, BUILDER, Set.of("fishofthieves"));
        }

        public String m_6055_() {
            return "Structure Modifier Registries: fishofthieves";
        }
    }
}

