/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.registry.variant;

import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.entity.variant.IslehopperVariant;
import com.stevekung.fishofthieves.registry.FOTRegistry;
import com.stevekung.fishofthieves.registry.FOTTags;
import com.stevekung.fishofthieves.spawn.SpawnSelectors;
import com.stevekung.fishofthieves.utils.TerrainUtils;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class IslehopperVariants {
    public static final IslehopperVariant STONE = IslehopperVariant.builder().condition(SpawnSelectors.always()).texture("stone").build();
    public static final IslehopperVariant MOSS = IslehopperVariant.builder().condition(SpawnSelectors.simpleSpawn(SpawnSelectors.biomeTag(FOTTags.Biomes.SPAWNS_MOSS_ISLEHOPPERS))).texture("moss").build();
    public static final IslehopperVariant HONEY = IslehopperVariant.builder().condition(SpawnSelectors.simpleSpawn(context -> {
        PoiManager poiManager = context.level().m_8904_();
        Optional optional = poiManager.m_27192_(type -> type.m_203565_(PoiTypes.f_218062_) || type.m_203565_(PoiTypes.f_218063_), context.blockPos(), 9, PoiManager.Occupancy.ANY);
        if (optional.isPresent()) {
            BlockState blockState = context.level().m_8055_((BlockPos)optional.get());
            return BeehiveBlockEntity.m_58752_((BlockState)blockState) == 5;
        }
        return false;
    })).texture("honey").build();
    public static final IslehopperVariant RAVEN = IslehopperVariant.builder().condition(SpawnSelectors.simpleSpawn(FishOfThieves.CONFIG.spawnRate.variant.ravenIslehopperProbability, SpawnSelectors.probability(FishOfThieves.CONFIG.spawnRate.variant.ravenIslehopperProbability).and(context -> context.blockPos().m_123342_() <= 0))).texture("raven").build();
    public static final IslehopperVariant AMETHYST = IslehopperVariant.builder().condition(SpawnSelectors.simpleSpawn(true, context -> TerrainUtils.lookForBlocksWithSize(context.blockPos(), 2, 16, blockPos2 -> context.level().m_8055_(blockPos2).m_204336_(FOTTags.Blocks.AMETHYST_ISLEHOPPER_SPAWNABLE_ON)))).texture("amethyst").glowTexture("amethyst_glow").build();

    public static void init() {
        IslehopperVariants.register("stone", STONE);
        IslehopperVariants.register("moss", MOSS);
        IslehopperVariants.register("honey", HONEY);
        IslehopperVariants.register("raven", RAVEN);
        IslehopperVariants.register("amethyst", AMETHYST);
    }

    private static void register(String key, IslehopperVariant variant) {
        Registry.m_122965_(FOTRegistry.ISLEHOPPER_VARIANT, (ResourceLocation)FishOfThieves.res(key), (Object)variant);
    }
}

